/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.utils;

import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;

public class AnnotationUtils {
    private static final String ATTRIBUTE_VALUE = "value";

    public static boolean hasAnnotation(IAnnotatable annotatable, String ... annotationNames) throws JavaModelException {
        return AnnotationUtils.getAnnotation(annotatable, annotationNames) != null;
    }

    public static IAnnotation getAnnotation(IAnnotatable annotatable, String ... annotationNames) throws JavaModelException {
        IAnnotation[] annotations;
        if (annotatable == null) {
            return null;
        }
        IAnnotation[] iAnnotationArray = annotations = annotatable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String[] stringArray = annotationNames;
            int n3 = annotationNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String annotationName = stringArray[n4];
                if (AnnotationUtils.isMatchAnnotation(annotation, annotationName)) {
                    return annotation;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isMatchAnnotation(IAnnotation annotation, String annotationName) {
        if (!annotationName.endsWith(annotation.getElementName())) {
            return false;
        }
        if (annotationName.equals(annotation.getElementName())) {
            return true;
        }
        return AnnotationUtils.isMatchAnnotationFullyQualifiedName(annotation, annotationName);
    }

    private static boolean isMatchAnnotationFullyQualifiedName(IAnnotation annotation, String annotationName) {
        IJavaElement[] elements;
        ICompilationUnit unit = (ICompilationUnit)annotation.getAncestor(5);
        if (unit == null) {
            return false;
        }
        IImportContainer container = unit.getImportContainer();
        if (container == null) {
            return false;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IElementInfo info = manager.getInfo((IJavaElement)container);
        if (info == null) {
            if (manager.getInfo((IJavaElement)unit) != null) {
                return false;
            }
            try {
                unit.open(null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            info = manager.getInfo((IJavaElement)container);
            if (info == null) {
                return false;
            }
        }
        IJavaElement[] iJavaElementArray = elements = ((ImportContainerInfo)info).getChildren();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String fqn;
            String qualifier;
            IJavaElement child = iJavaElementArray[n2];
            IImportDeclaration importDeclaration = (IImportDeclaration)child;
            if (importDeclaration.isOnDemand() ? (qualifier = (fqn = importDeclaration.getElementName()).substring(0, fqn.lastIndexOf(46))).equals(annotationName.substring(0, annotationName.lastIndexOf(46))) : importDeclaration.getElementName().equals(annotationName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isMatchAnnotation(Annotation annotation, String annotationName) {
        return annotationName.endsWith(annotation.getTypeName().getFullyQualifiedName());
    }

    public static String getAnnotationMemberValue(IAnnotation annotation, String memberName) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (memberName.equals(pair.getMemberName())) {
                return AnnotationUtils.getValueAsString(pair);
            }
            ++n2;
        }
        return null;
    }

    public static Boolean getAnnotationMemberValueAsBoolean(IAnnotation annotation, String memberName) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (memberName.equals(pair.getMemberName())) {
                return AnnotationUtils.getValueAsBoolean(pair);
            }
            ++n2;
        }
        return null;
    }

    public static String getValueAsString(IMemberValuePair pair) {
        return pair.getValue() != null ? pair.getValue().toString() : null;
    }

    public static Boolean getValueAsBoolean(IMemberValuePair pair) {
        if (pair.getValue() == null) {
            return null;
        }
        return "true".equals(pair.getValue().toString()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object[] getValueAsArray(IMemberValuePair pair) {
        if (pair.getValue() == null) {
            return null;
        }
        if (pair.getValue() instanceof Object[]) {
            return (Object[])pair.getValue();
        }
        return new Object[]{pair.getValue()};
    }

    public static Expression getAnnotationMemberValueExpression(Annotation annotation, String memberName) throws JavaModelException {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            for (Object pair : normalAnnotation.values()) {
                MemberValuePair castPair = (MemberValuePair)pair;
                if (!memberName.equals(castPair.getName().toString())) continue;
                return castPair.getValue();
            }
            return null;
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            return ATTRIBUTE_VALUE.equals(memberName) || singleMemberAnnotation.getProperty(memberName) != null ? singleMemberAnnotation.getValue() : null;
        }
        return null;
    }

    public static Boolean getBoolean(Expression expression) {
        if (expression == null) {
            return null;
        }
        Object expressionValue = expression.resolveConstantExpressionValue();
        if (expressionValue instanceof Boolean) {
            return (Boolean)expressionValue;
        }
        return null;
    }

    public static String getString(Expression expression) {
        if (expression == null) {
            return null;
        }
        Object expressionValue = expression.resolveConstantExpressionValue();
        if (expressionValue instanceof String) {
            return (String)expressionValue;
        }
        return null;
    }
}

