/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.template.datamodel;

import com.redhat.qute.jdt.template.datamodel.AbstractDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;

public abstract class AbstractInterfaceImplementationDataModelProvider
extends AbstractDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractInterfaceImplementationDataModelProvider.class.getName());

    @Override
    protected String[] getPatterns() {
        return this.getInterfaceNames();
    }

    protected abstract String[] getInterfaceNames();

    @Override
    protected SearchPattern createSearchPattern(String interfaceName) {
        return AbstractInterfaceImplementationDataModelProvider.createInterfaceImplementationSearchPattern(interfaceName);
    }

    @Override
    public void collectDataModel(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        block4: {
            Object element = match.getElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                try {
                    if (this.isApplicable(type)) {
                        this.processType(type, context, monitor);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, "Cannot collect Qute data model for the type '" + type.getElementName() + "'.", e);
                }
            }
        }
    }

    private boolean isApplicable(IType type) throws JavaModelException {
        String[] superInterfaceNames = type.getSuperInterfaceNames();
        if (superInterfaceNames == null || superInterfaceNames.length == 0) {
            return false;
        }
        String[] stringArray = this.getInterfaceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            String[] stringArray2 = superInterfaceNames;
            int n3 = superInterfaceNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String superInterfaceName = stringArray2[n4];
                if (interfaceName.endsWith(superInterfaceName)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    protected abstract void processType(IType var1, SearchContext var2, IProgressMonitor var3) throws JavaModelException;
}

