/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.template.datamodel;

import com.redhat.qute.jdt.template.datamodel.AbstractDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;

public abstract class AbstractFieldDeclarationTypeReferenceDataModelProvider
extends AbstractDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractFieldDeclarationTypeReferenceDataModelProvider.class.getName());

    @Override
    protected String[] getPatterns() {
        return this.getTypeNames();
    }

    protected abstract String[] getTypeNames();

    @Override
    protected SearchPattern createSearchPattern(String className) {
        return AbstractFieldDeclarationTypeReferenceDataModelProvider.createFieldDeclarationTypeReferenceSearchPattern(className);
    }

    @Override
    public void collectDataModel(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        block4: {
            Object element = match.getElement();
            if (element instanceof IField) {
                IField field = (IField)element;
                if (!this.isApplicable(field)) {
                    return;
                }
                try {
                    this.processField(field, context, monitor);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, "Cannot collect Qute data model for the field '" + field.getDeclaringType().getElementName() + "#" + field.getElementName() + "'.", e);
                }
            }
        }
    }

    private boolean isApplicable(IField field) {
        String fieldTypeName = JDTTypeUtils.getResolvedTypeName(field);
        if (fieldTypeName == null) {
            return false;
        }
        String[] stringArray = this.getTypeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            if (typeName.endsWith(fieldTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract void processField(IField var1, SearchContext var2, IProgressMonitor var3) throws JavaModelException;
}

