/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.resolvedtype;

import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.internal.template.resolvedtype.AbstractResolvedJavaTypeFactory;
import com.redhat.qute.jdt.internal.template.resolvedtype.IResolvedJavaTypeFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class DefaultResolvedJavaTypeFactory
extends AbstractResolvedJavaTypeFactory {
    private static final Logger LOGGER = Logger.getLogger(DefaultResolvedJavaTypeFactory.class.getName());
    private static final IResolvedJavaTypeFactory INSTANCE = new DefaultResolvedJavaTypeFactory();

    public static IResolvedJavaTypeFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isAdaptedFor(ValueResolverKind kind) {
        return true;
    }

    @Override
    protected boolean isValidField(IField field, IType type) throws JavaModelException {
        if (type.isEnum()) {
            return true;
        }
        return Flags.isPublic((int)field.getFlags());
    }

    @Override
    protected boolean isValidRecordField(IField field, IType type) {
        return true;
    }

    @Override
    protected InvalidMethodReason getValidMethodForQute(IMethod method, String typeName) {
        if ("java.lang.Object".equals(typeName)) {
            return InvalidMethodReason.FromObject;
        }
        try {
            if ("V".equals(method.getReturnType())) {
                return InvalidMethodReason.VoidReturn;
            }
            if (Flags.isStatic((int)method.getFlags())) {
                return InvalidMethodReason.Static;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while checking if '" + method.getElementName() + "' is valid.", e);
        }
        return null;
    }
}

