/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TemplateGlobalAnnotationSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(TemplateGlobalAnnotationSupport.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.qute.TemplateGlobal"};
    private static final String GLOBAL_NAMESPACE = "global";

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (!(javaElement instanceof IAnnotatable)) {
            return;
        }
        if (annotation == null) {
            return;
        }
        ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)javaElement);
        if (javaElement.getElementType() == 7) {
            IType type = (IType)javaElement;
            this.collectResolversForTemplateGlobal(type, annotation, context.getDataModelProject().getValueResolvers(), typeResolver, monitor);
        } else if (javaElement.getElementType() == 8 || javaElement.getElementType() == 9) {
            IMember member = (IMember)javaElement;
            this.collectResolversForTemplateGlobal(member, annotation, context.getDataModelProject().getValueResolvers(), typeResolver, monitor);
        }
    }

    private void collectResolversForTemplateGlobal(IType type, IAnnotation templateGlobal, List<ValueResolverInfo> resolvers, ITypeResolver typeResolver, IProgressMonitor monitor) {
        try {
            IMethod[] methods;
            IField[] fields;
            IField[] iFieldArray = fields = type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (!AnnotationUtils.hasAnnotation((IAnnotatable)field, "io.quarkus.qute.TemplateGlobal") && TemplateGlobalAnnotationSupport.isTemplateGlobalMember((IMember)field)) {
                    this.collectResolversForTemplateGlobal((IMember)field, templateGlobal, resolvers, typeResolver, monitor);
                }
                ++n2;
            }
            IMethod[] iMethodArray = methods = type.getMethods();
            int n3 = methods.length;
            n = 0;
            while (n < n3) {
                IMethod method = iMethodArray[n];
                if (!AnnotationUtils.hasAnnotation((IAnnotatable)method, "io.quarkus.qute.TemplateGlobal") && TemplateGlobalAnnotationSupport.isTemplateGlobalMember((IMember)method)) {
                    this.collectResolversForTemplateGlobal((IMember)method, templateGlobal, resolvers, typeResolver, monitor);
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting methods of '" + type.getElementName() + "'.", e);
        }
    }

    private void collectResolversForTemplateGlobal(IMember member, IAnnotation templateGlobal, List<ValueResolverInfo> resolvers, ITypeResolver typeResolver, IProgressMonitor monitor) {
        if (TemplateGlobalAnnotationSupport.isTemplateGlobalMember(member)) {
            String sourceType = member.getDeclaringType().getFullyQualifiedName();
            ValueResolverInfo resolver = new ValueResolverInfo();
            resolver.setSourceType(sourceType);
            resolver.setSignature(typeResolver.resolveSignature((IJavaElement)member));
            resolver.setNamespace(GLOBAL_NAMESPACE);
            resolver.setKind(ValueResolverKind.TemplateGlobal);
            try {
                resolver.setNamed(AnnotationUtils.getAnnotationMemberValue(templateGlobal, "name"));
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.SEVERE, "Error while getting annotation member value of 'name'.", e);
            }
            resolver.setGlobalVariable(true);
            if (!resolvers.contains(resolver)) {
                resolvers.add(resolver);
            }
        }
    }

    private static boolean isTemplateGlobalMember(IMember member) {
        block3: {
            block4: {
                try {
                    if (JDTTypeUtils.isPrivateMember(member) || !JDTTypeUtils.isStaticMember(member)) break block3;
                    if (member.getElementType() != 8) break block4;
                    return true;
                }
                catch (JavaModelException e) {
                    LOGGER.log(Level.SEVERE, "Error while getting method information of '" + member.getElementName() + "'.", e);
                    return false;
                }
            }
            if (member.getElementType() != 9) break block3;
            IMethod method = (IMethod)member;
            return method.getNumberOfParameters() == 0 && !JDTTypeUtils.isVoidReturnType(method);
        }
        return false;
    }
}

