/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.jdt.internal.AnnotationLocationSupport;
import com.redhat.qute.jdt.internal.template.TemplateDataSupport;
import com.redhat.qute.jdt.template.datamodel.AbstractFieldDeclarationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.TemplateNameStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;

public class TemplateFieldSupport
extends AbstractFieldDeclarationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(TemplateFieldSupport.class.getName());
    private static final String[] TYPE_NAMES = new String[]{"io.quarkus.qute.Template"};
    private static final String KEY = TemplateFieldSupport.class.getName() + "#";

    @Override
    protected String[] getTypeNames() {
        return TYPE_NAMES;
    }

    @Override
    protected void processField(IField field, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit compilationUnit = field.getCompilationUnit();
        AnnotationLocationSupport annotationLocationSupport = TemplateFieldSupport.getAnnotationLocationSupport(compilationUnit, context);
        StringLiteral location = annotationLocationSupport.getLocationExpressionFromConstructorParameter(field.getElementName());
        TemplateFieldSupport.collectDataModelTemplateForTemplateField(field, context.getDataModelProject().getTemplates(), location != null ? location.getLiteralValue() : null, monitor);
    }

    private static AnnotationLocationSupport getAnnotationLocationSupport(ICompilationUnit compilationUnit, SearchContext context) {
        AnnotationLocationSupport unitSupport;
        HashMap<ICompilationUnit, AnnotationLocationSupport> allSupport = (HashMap<ICompilationUnit, AnnotationLocationSupport>)context.get(KEY);
        if (allSupport == null) {
            allSupport = new HashMap<ICompilationUnit, AnnotationLocationSupport>();
            context.put(KEY, allSupport);
        }
        if ((unitSupport = (AnnotationLocationSupport)((Object)allSupport.get(compilationUnit))) == null) {
            CompilationUnit root = ASTResolving.createQuickFixAST((ICompilationUnit)compilationUnit, null);
            unitSupport = new AnnotationLocationSupport(root);
            allSupport.put(compilationUnit, unitSupport);
        }
        return unitSupport;
    }

    private static void collectDataModelTemplateForTemplateField(IField field, List<DataModelTemplate<DataModelParameter>> templates, String location, IProgressMonitor monitor) {
        DataModelTemplate<DataModelParameter> template = TemplateFieldSupport.createTemplateDataModel(field, location, monitor);
        templates.add(template);
    }

    private static DataModelTemplate<DataModelParameter> createTemplateDataModel(IField field, String locationFromConstructorParameter, IProgressMonitor monitor) {
        String location = locationFromConstructorParameter != null ? locationFromConstructorParameter : TemplateFieldSupport.getLocation((IAnnotatable)field);
        String fieldName = field.getElementName();
        String templateUri = JDTQuteProjectUtils.getTemplatePath(null, null, location != null ? location : fieldName, true, TemplateNameStrategy.ELEMENT_NAME).getTemplateUri();
        DataModelTemplate<DataModelParameter> template = new DataModelTemplate<DataModelParameter>();
        template.setParameters(new ArrayList());
        template.setTemplateUri(templateUri);
        template.setSourceType(field.getDeclaringType().getFullyQualifiedName());
        template.setSourceField(fieldName);
        TemplateDataSupport.collectParametersFromDataMethodInvocation((IMember)field, template, monitor);
        return template;
    }

    private static String getLocation(IAnnotatable field) {
        try {
            IAnnotation annotation = AnnotationUtils.getAnnotation(field, "io.quarkus.qute.Location");
            if (annotation != null) {
                return AnnotationUtils.getAnnotationMemberValue(annotation, "value");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while getting @Location of '" + ((IJavaElement)field).getElementName() + "'.", e);
        }
        return null;
    }
}

