/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TemplateEnumAnnotationSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(TemplateEnumAnnotationSupport.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.qute.TemplateEnum"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() != 7) {
            return;
        }
        IType type = (IType)javaElement;
        if (!type.isEnum()) {
            return;
        }
        IAnnotation templateEnum = AnnotationUtils.getAnnotation((IAnnotatable)javaElement, "io.quarkus.qute.TemplateEnum");
        if (templateEnum == null) {
            return;
        }
        IAnnotation templateData = AnnotationUtils.getAnnotation((IAnnotatable)javaElement, "io.quarkus.qute.TemplateData");
        if (templateData != null) {
            return;
        }
        TemplateEnumAnnotationSupport.collectResolversForTemplateEnum(type, context.getDataModelProject().getValueResolvers(), monitor);
    }

    private static void collectResolversForTemplateEnum(IType type, List<ValueResolverInfo> resolvers, IProgressMonitor monitor) {
        try {
            IField[] fields;
            ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)type);
            IField[] iFieldArray = fields = type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                TemplateEnumAnnotationSupport.collectResolversForTemplateEnum(field, resolvers, typeResolver);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting methods of '" + type.getElementName() + "'.", e);
        }
    }

    private static void collectResolversForTemplateEnum(IField field, List<ValueResolverInfo> resolvers, ITypeResolver typeResolver) {
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setSourceType(field.getDeclaringType().getFullyQualifiedName());
        resolver.setSignature(typeResolver.resolveFieldSignature(field));
        resolver.setKind(ValueResolverKind.TemplateEnum);
        resolver.setNamespace(field.getDeclaringType().getElementName());
        if (!resolvers.contains(resolver)) {
            resolvers.add(resolver);
        }
    }
}

