/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TemplateDataAnnotationSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(TemplateDataAnnotationSupport.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.qute.TemplateData"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        IMethod[] methods;
        IField[] fields;
        if (javaElement.getElementType() != 7) {
            return;
        }
        IType type = (IType)javaElement;
        String namespace = null;
        boolean hasTemplateData = false;
        IAnnotation[] iAnnotationArray = type.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation typeAnnotation = iAnnotationArray[n2];
            if (AnnotationUtils.isMatchAnnotation(typeAnnotation, "io.quarkus.qute.TemplateData")) {
                hasTemplateData = true;
                namespace = AnnotationUtils.getAnnotationMemberValue(typeAnnotation, "namespace");
                if (StringUtils.isNotEmpty((CharSequence)namespace)) break;
            }
            ++n2;
        }
        if (!hasTemplateData) {
            return;
        }
        ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)type);
        IField[] iFieldArray = fields = type.getFields();
        int n3 = fields.length;
        int n4 = 0;
        while (n4 < n3) {
            IField field = iFieldArray[n4];
            this.collectResolversForTemplateData((IMember)field, namespace, context.getDataModelProject().getValueResolvers(), typeResolver, monitor);
            ++n4;
        }
        IMethod[] iMethodArray = methods = type.getMethods();
        int n5 = methods.length;
        n3 = 0;
        while (n3 < n5) {
            IMethod method = iMethodArray[n3];
            this.collectResolversForTemplateData((IMember)method, namespace, context.getDataModelProject().getValueResolvers(), typeResolver, monitor);
            ++n3;
        }
    }

    private void collectResolversForTemplateData(IMember member, String namespace, List<ValueResolverInfo> resolvers, ITypeResolver typeResolver, IProgressMonitor monitor) {
        try {
            if (JDTTypeUtils.isPublicMember(member) && JDTTypeUtils.isStaticMember(member)) {
                String sourceType = member.getDeclaringType().getFullyQualifiedName();
                ValueResolverInfo resolver = new ValueResolverInfo();
                resolver.setSourceType(sourceType);
                resolver.setSignature(typeResolver.resolveSignature((IJavaElement)member));
                resolver.setNamespace(StringUtils.isNotEmpty((CharSequence)namespace) ? namespace : sourceType.replace('.', '_'));
                resolver.setKind(ValueResolverKind.TemplateData);
                if (!resolvers.contains(resolver)) {
                    resolvers.add(resolver);
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting annotation member value of '" + member.getElementName() + "'.", e);
        }
    }
}

