/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template;

import com.redhat.qute.commons.datamodel.DataModelBaseTemplate;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.jdt.internal.template.TemplateDataCollector;
import com.redhat.qute.jdt.internal.template.TemplateDataLocation;
import com.redhat.qute.jdt.internal.template.TemplateDataVisitor;
import com.redhat.qute.jdt.utils.IJDTUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4j.Location;

public class TemplateDataSupport {
    private static final Logger LOGGER = Logger.getLogger(TemplateDataSupport.class.getName());

    public static void collectParametersFromDataMethodInvocation(IMember fieldOrMethod, DataModelBaseTemplate<DataModelParameter> template, IProgressMonitor monitor) {
        try {
            TemplateDataSupport.search(fieldOrMethod, new TemplateDataCollector(template, monitor), monitor);
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Error while getting collecting template parameters for '" + fieldOrMethod.getElementName() + "'.", e);
        }
    }

    private static void search(IMember fieldOrMethod, final TemplateDataVisitor visitor, IProgressMonitor monitor) throws CoreException {
        boolean searchInJavaProject = TemplateDataSupport.isSearchInJavaProject(fieldOrMethod);
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)fieldOrMethod, (int)2);
        int searchScope = 1;
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((boolean)true, (IJavaElement[])new IJavaElement[]{searchInJavaProject ? fieldOrMethod.getJavaProject() : fieldOrMethod.getCompilationUnit()}, (int)searchScope);
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object o = match.getElement();
                if (o instanceof IMethod) {
                    IMethod method = (IMethod)o;
                    visitor.setMethod(method);
                    CompilationUnit cu = TemplateDataSupport.getASTRoot((ITypeRoot)method.getCompilationUnit());
                    ASTNode methodDeclarationAST = new NodeFinder((ASTNode)cu, method.getSourceRange().getOffset(), method.getSourceRange().getLength()).getCoveringNode();
                    methodDeclarationAST.accept((ASTVisitor)visitor);
                }
            }
        }, monitor);
    }

    private static boolean isSearchInJavaProject(IMember fieldOrMethod) {
        if (fieldOrMethod.getElementType() == 8) {
            return false;
        }
        IType type = fieldOrMethod.getDeclaringType();
        boolean innerClass = type.getParent() != null && type.getParent().getElementType() == 7;
        return innerClass;
    }

    public static Location getDataMethodInvocationLocation(IMember fieldOrMethod, String parameterName, IJDTUtils utils, IProgressMonitor monitor) {
        try {
            TemplateDataLocation dataLocation = new TemplateDataLocation(parameterName, utils);
            TemplateDataSupport.search(fieldOrMethod, dataLocation, monitor);
            return dataLocation.getLocation();
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Error while getting location template.data for '" + fieldOrMethod.getElementName() + "'.", e);
            return null;
        }
    }

    private static CompilationUnit getASTRoot(ITypeRoot typeRoot) {
        return ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)typeRoot), null);
    }
}

