/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template;

import com.redhat.qute.commons.datamodel.DataModelBaseTemplate;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.jdt.internal.template.TemplateDataVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.StringLiteral;

public class TemplateDataCollector
extends TemplateDataVisitor {
    private final DataModelBaseTemplate<DataModelParameter> template;

    public TemplateDataCollector(DataModelBaseTemplate<DataModelParameter> template, IProgressMonitor monitor) {
        this.template = template;
    }

    @Override
    protected boolean visitParameter(Object name, Object type) {
        String paramName = null;
        if (name instanceof StringLiteral) {
            paramName = ((StringLiteral)name).getLiteralValue();
        }
        if (paramName != null) {
            String paramType = "java.lang.Object";
            if (type instanceof Expression) {
                ITypeBinding binding = ((Expression)type).resolveTypeBinding();
                paramType = binding.getQualifiedName();
            }
            if (paramName != null && this.template.getParameter(paramName) == null) {
                DataModelParameter parameter = new DataModelParameter();
                parameter.setKey(paramName);
                parameter.setSourceType(paramType);
                parameter.setDataMethodInvocation(true);
                this.template.addParameter(parameter);
            }
        }
        return true;
    }
}

