/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template;

import com.redhat.qute.commons.QuteProjectScope;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.usertags.UserTagInfo;
import com.redhat.qute.jdt.internal.template.datamodel.DataModelProviderRegistry;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;

public class QuarkusIntegrationForQute {
    private static final String TEMPLATES_TAGS_ENTRY = "templates.tags";
    private static final Logger LOGGER = Logger.getLogger(QuarkusIntegrationForQute.class.getName());
    private static final String JDT_SCHEME = "jdt";
    private static final String CONTENTS_AUTHORITY = "jarentry";

    public static DataModelProject<DataModelTemplate<DataModelParameter>> getDataModelProject(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        return DataModelProviderRegistry.getInstance().getDataModelProject(javaProject, QuteProjectScope.SOURCES_AND_DEPENDENCIES, monitor);
    }

    public static List<UserTagInfo> getUserTags(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] resolvedClasspath;
        ArrayList<UserTagInfo> tags = new ArrayList<UserTagInfo>();
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath = ((JavaProject)javaProject).getResolvedClasspath();
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (!entry.isTest()) {
                switch (entry.getEntryKind()) {
                    case 1: {
                        String jarPath = entry.getPath().toOSString();
                        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot(jarPath);
                        if (root == null || !root.exists()) break;
                        QuarkusIntegrationForQute.collectUserTags(root, tags);
                    }
                }
            }
            ++n2;
        }
        return tags;
    }

    private static void collectUserTags(IPackageFragmentRoot root, List<UserTagInfo> tags) throws JavaModelException, CoreException {
        IJavaElement[] children;
        IJavaElement[] iJavaElementArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] resources;
            IPackageFragment packageRoot;
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IPackageFragment && TEMPLATES_TAGS_ENTRY.equals((packageRoot = (IPackageFragment)child).getElementName()) && (resources = packageRoot.getNonJavaResources()) != null) {
                Object[] objectArray = resources;
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray[n4];
                    if (object instanceof IJarEntryResource) {
                        IJarEntryResource templateFile = (IJarEntryResource)object;
                        String fileName = templateFile.getName();
                        String uri = QuarkusIntegrationForQute.toUri(templateFile);
                        String content = QuarkusIntegrationForQute.convertStreamToString(templateFile.getContents());
                        UserTagInfo tagInfo = new UserTagInfo();
                        tagInfo.setFileName(fileName);
                        tagInfo.setUri(uri);
                        tagInfo.setContent(content);
                        tags.add(tagInfo);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static String convertStreamToString(InputStream is) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner s = new Scanner(is);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String toUri(IJarEntryResource jarEntryFile) {
        IPackageFragmentRoot fragmentRoot = jarEntryFile.getPackageFragmentRoot();
        try {
            return new URI(JDT_SCHEME, CONTENTS_AUTHORITY, jarEntryFile.getFullPath().toPortableString(), fragmentRoot.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, "Error while generating URI for jarentryfile ", e);
            return null;
        }
    }
}

