/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template;

import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.JavaTypeKind;
import com.redhat.qute.jdt.internal.resolver.AbstractTypeResolver;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;

public class JavaTypesSearch {
    private static final Logger LOGGER = Logger.getLogger(JavaTypesSearch.class.getName());
    private final IJavaProject javaProject;
    private final String packageName;
    private final String typeName;
    private final IJavaSearchScope scope;

    public JavaTypesSearch(String pattern, IJavaProject javaProject) {
        this.javaProject = javaProject;
        Object typeName = pattern;
        String packageName = null;
        int searchScope = 1;
        IJavaProject innerClass = null;
        if (StringUtils.isNotEmpty((CharSequence)typeName)) {
            searchScope = 7;
            int index = ((String)typeName).lastIndexOf(46);
            if (index != -1) {
                packageName = ((String)typeName).substring(0, index);
                typeName = ((String)typeName).substring(index + 1, ((String)typeName).length());
                try {
                    innerClass = javaProject.findType(packageName);
                    if (innerClass != null) {
                        packageName = null;
                    }
                }
                catch (JavaModelException e) {
                    LOGGER.log(Level.SEVERE, "Error while getting inner class for '" + packageName + "'.", e);
                }
            }
        }
        this.typeName = typeName = (String)typeName + "*";
        this.packageName = packageName;
        this.scope = BasicSearchEngine.createJavaSearchScope((boolean)true, (IJavaElement[])new IJavaElement[]{innerClass != null ? innerClass : javaProject}, (int)searchScope);
    }

    public List<JavaTypeInfo> search(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<JavaTypeInfo> javaTypes = new ArrayList<JavaTypeInfo>();
        this.collectPackages(javaTypes);
        this.collectClassesAndInterfaces(monitor, javaTypes);
        return javaTypes;
    }

    private void collectPackages(List<JavaTypeInfo> javaTypes) {
        if (this.packageName != null) {
            HashSet<String> subPackages = new HashSet<String>();
            try {
                IPackageFragmentRoot[] packageFragmentRoots = this.javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    this.fillWithSubPackages(this.packageName, packageFragmentRoots[i], subPackages);
                    ++i;
                }
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.SEVERE, "Error while collecting sub packages for '" + this.packageName + "'.", e);
            }
            for (String subPackageName : subPackages) {
                JavaTypeInfo packageInfo = new JavaTypeInfo();
                packageInfo.setJavaTypeKind(JavaTypeKind.Package);
                packageInfo.setSignature(subPackageName);
                javaTypes.add(packageInfo);
            }
        }
    }

    private void fillWithSubPackages(String packageName, IPackageFragmentRoot packageFragmentRoot, Set<String> subPackages) {
        try {
            IJavaElement[] allPackages = packageFragmentRoot.getChildren();
            int i = 0;
            while (i < allPackages.length) {
                IPackageFragment packageFragment = (IPackageFragment)allPackages[i];
                String subPackageName = packageFragment.getElementName();
                if (subPackageName.startsWith(packageName)) {
                    subPackages.add(subPackageName);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while collecting sub packages for '" + packageName + "' in '" + packageFragmentRoot.getElementName() + "'.", e);
        }
    }

    private void collectClassesAndInterfaces(IProgressMonitor monitor, final List<JavaTypeInfo> javaTypes) throws JavaModelException {
        SearchEngine engine = new SearchEngine();
        engine.searchAllTypeNames(this.packageName == null ? null : this.packageName.toCharArray(), 0, this.typeName.toCharArray(), 10, 10, this.scope, new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                IType type = match.getType();
                String typeSignature = AbstractTypeResolver.resolveJavaTypeSignature(type);
                JavaTypeInfo classInfo = new JavaTypeInfo();
                classInfo.setSignature(typeSignature);
                javaTypes.add(classInfo);
                try {
                    classInfo.setJavaTypeKind(JDTTypeUtils.getJavaTypeKind(type));
                }
                catch (JavaModelException e) {
                    LOGGER.log(Level.SEVERE, "Error while collecting Java Types for '" + JavaTypesSearch.this.packageName + " package and Java type '" + JavaTypesSearch.this.typeName + "'.", e);
                }
            }
        }, 3, monitor);
    }
}

