/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.resolver;

import com.redhat.qute.jdt.internal.resolver.AbstractTypeResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.JavaModelException;

public class CompilationUnitTypeResolver
extends AbstractTypeResolver {
    private static final Logger LOGGER = Logger.getLogger(CompilationUnitTypeResolver.class.getName());
    private final Map<String, String> packages = new HashMap<String, String>();

    public CompilationUnitTypeResolver(ICompilationUnit compilationUnit) {
        super(compilationUnit.findPrimaryType());
        try {
            IImportDeclaration[] imports = compilationUnit.getImports();
            if (imports != null) {
                int i = 0;
                while (i < imports.length) {
                    String name = imports[i].getElementName();
                    int importedIndex = name.lastIndexOf(46);
                    String importedClassName = name.substring(importedIndex + 1, name.length());
                    this.packages.put(importedClassName, name);
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while creating packages cache for '" + compilationUnit.getElementName() + "'.", e);
        }
    }

    @Override
    protected String resolveSimpleType(String type) {
        try {
            String resolvedType;
            if (type.indexOf(46) == -1 && (resolvedType = this.packages.get(type)) != null) {
                return resolvedType;
            }
            String[][] resolvedNames = this.primaryType.resolveType(type);
            if (resolvedNames != null && resolvedNames.length > 0) {
                String packageName = resolvedNames[0][0];
                String className = resolvedNames[0][1];
                if (className.indexOf(46) != -1) {
                    className = className.replace('.', '$');
                }
                if (packageName.isBlank()) {
                    return className;
                }
                return packageName + "." + className;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while resolving simple type '" + type + "'.", e);
        }
        return type;
    }
}

