/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.ls;

import com.redhat.qute.commons.DocumentFormat;
import com.redhat.qute.commons.FileUtils;
import com.redhat.qute.commons.GenerateMissingJavaMemberParams;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.QuteJavaTypesParams;
import com.redhat.qute.commons.QuteJavadocParams;
import com.redhat.qute.commons.QuteProjectParams;
import com.redhat.qute.commons.QuteResolvedJavaTypeParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.TemplateRootPath;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.QuteDataModelProjectParams;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.commons.usertags.QuteUserTagParams;
import com.redhat.qute.commons.usertags.UserTagInfo;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.ls.AbstractQuteDelegateCommandHandler;
import com.redhat.qute.jdt.internal.ls.ArgumentUtils;
import com.redhat.qute.jdt.internal.ls.JDTUtilsLSImpl;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.WorkspaceEdit;

public class QuteSupportForTemplateDelegateCommandHandler
extends AbstractQuteDelegateCommandHandler {
    private static final Logger LOGGER = Logger.getLogger(QuteSupportForTemplateDelegateCommandHandler.class.getName());
    private static final String PROJECT_URI_ATTR = "projectUri";
    private static final String PATTERN_ATTR = "pattern";
    private static final String SOURCE_TYPE_ATTR = "sourceType";
    private static final String SOURCE_METHOD_ATTR = "sourceMethod";
    private static final String SOURCE_PARAMETER_ATTR = "sourceParameter";
    private static final String DATA_METHOD_INVOCATION_ATTR = "dataMethodInvocation";
    private static final String SOURCE_FIELD_ATTR = "sourceField";
    private static final String TEMPLATE_FILE_URI_ATTR = "templateFileUri";
    private static final String CLASS_NAME_ATTR = "className";
    private static final String QUTE_TEMPLATE_PROJECTS_COMMAND_ID = "qute/template/projects";
    private static final String QUTE_TEMPLATE_PROJECT_COMMAND_ID = "qute/template/project";
    private static final String QUTE_TEMPLATE_PROJECT_DATA_MODEL_COMMAND_ID = "qute/template/projectDataModel";
    private static final String QUTE_TEMPLATE_USER_TAGS_COMMAND_ID = "qute/template/userTags";
    private static final String QUTE_TEMPLATE_JAVA_TYPES_COMMAND_ID = "qute/template/javaTypes";
    private static final String QUTE_TEMPLATE_JAVA_DEFINITION_COMMAND_ID = "qute/template/javaDefinition";
    private static final String QUTE_TEMPLATE_RESOLVED_JAVA_TYPE_COMMAND_ID = "qute/template/resolvedJavaType";
    private static final String QUTE_JAVADOC_RESOLVE_COMMAND_ID = "qute/template/javadoc";
    private static final String QUTE_TEMPLATE_GENERATE_MISSING_JAVA_MEMBER = "qute/template/generateMissingJavaMember";
    private static final String QUTE_TEMPLATE_IS_IN_TEMPLATE = "qute/template/isInTemplate";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        switch (commandId) {
            case "qute/template/projects": {
                return QuteSupportForTemplateDelegateCommandHandler.getProjects(commandId, monitor);
            }
            case "qute/template/project": {
                return QuteSupportForTemplateDelegateCommandHandler.getProjectInfo(arguments, commandId, monitor);
            }
            case "qute/template/projectDataModel": {
                return QuteSupportForTemplateDelegateCommandHandler.getProjectDataModel(arguments, commandId, monitor);
            }
            case "qute/template/userTags": {
                return QuteSupportForTemplateDelegateCommandHandler.getUserTags(arguments, commandId, monitor);
            }
            case "qute/template/javaTypes": {
                return QuteSupportForTemplateDelegateCommandHandler.getJavaTypes(arguments, commandId, monitor);
            }
            case "qute/template/resolvedJavaType": {
                return QuteSupportForTemplateDelegateCommandHandler.getResolvedJavaType(arguments, commandId, monitor);
            }
            case "qute/template/javaDefinition": {
                return QuteSupportForTemplateDelegateCommandHandler.getJavaDefinition(arguments, commandId, monitor);
            }
            case "qute/template/javadoc": {
                return QuteSupportForTemplateDelegateCommandHandler.getJavadoc(arguments, commandId, monitor);
            }
            case "qute/template/generateMissingJavaMember": {
                return QuteSupportForTemplateDelegateCommandHandler.generateMissingJavaMember(arguments, commandId, monitor);
            }
            case "qute/template/isInTemplate": {
                return QuteSupportForTemplateDelegateCommandHandler.isInTemplate(arguments, commandId, monitor);
            }
        }
        return null;
    }

    private static List<ProjectInfo> getProjects(String commandId, IProgressMonitor monitor) {
        return QuteSupportForTemplate.getInstance().getProjects(JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static ProjectInfo getProjectInfo(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        QuteProjectParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteProjectParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().getProjectInfo(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteProjectParams createQuteProjectParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteProjectParams argument!", commandId));
        }
        String templateFileUri = ArgumentUtils.getString(obj, TEMPLATE_FILE_URI_ATTR);
        if (templateFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteProjectParams.templateFileUri!", commandId));
        }
        return new QuteProjectParams(templateFileUri);
    }

    private static DataModelProject<DataModelTemplate<DataModelParameter>> getProjectDataModel(List<Object> arguments, String commandId, IProgressMonitor monitor) throws Exception {
        QuteDataModelProjectParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteProjectDataModelParams(arguments, commandId);
        AtomicReference<Object> dataModelRef = new AtomicReference<Object>(null);
        Job job = Job.create((String)"Qute data model collector", progress -> {
            DataModelProject<DataModelTemplate<DataModelParameter>> project = QuteSupportForTemplate.getInstance().getDataModelProject(params, JDTUtilsLSImpl.getInstance(), progress);
            dataModelRef.set(project);
        });
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Error while joining Qute data model collector job", e);
        }
        Exception jobException = (Exception)job.getResult().getException();
        if (jobException != null) {
            if (jobException.getCause() != null) {
                throw (Exception)jobException.getCause();
            }
            throw jobException;
        }
        return dataModelRef.get();
    }

    private static QuteDataModelProjectParams createQuteProjectDataModelParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteProjectDataModelParams argument!", commandId));
        }
        String projectUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (projectUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteProjectDataModelParams.projectUri!", commandId));
        }
        return new QuteDataModelProjectParams(projectUri);
    }

    private static List<UserTagInfo> getUserTags(List<Object> arguments, String commandId, IProgressMonitor monitor) throws CoreException {
        QuteUserTagParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteUserTagParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().getUserTags(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteUserTagParams createQuteUserTagParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteUserTagParams argument!", commandId));
        }
        String projectUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (projectUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteUserTagParams.projectUri!", commandId));
        }
        return new QuteUserTagParams(projectUri);
    }

    private static ResolvedJavaTypeInfo getResolvedJavaType(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        QuteResolvedJavaTypeParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteResolvedJavaTypeParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().getResolvedJavaType(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteResolvedJavaTypeParams createQuteResolvedJavaTypeParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteResolvedJavaTypeParams argument!", commandId));
        }
        String projectUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (projectUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteResolvedJavaTypeParams.projectUri!", commandId));
        }
        String className = ArgumentUtils.getString(obj, CLASS_NAME_ATTR);
        if (className == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteResolvedJavaTypeParams.className!", commandId));
        }
        ValueResolverKind kind = null;
        try {
            kind = ValueResolverKind.forValue(ArgumentUtils.getInt(obj, "kind"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return new QuteResolvedJavaTypeParams(className, kind, projectUri);
    }

    private static List<JavaTypeInfo> getJavaTypes(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        QuteJavaTypesParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteJavaTypesParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().getJavaTypes(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteJavaTypesParams createQuteJavaTypesParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteJavaTypesParams argument!", commandId));
        }
        String projectUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (projectUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaTypesParams.projectUri!", commandId));
        }
        String pattern = ArgumentUtils.getString(obj, PATTERN_ATTR);
        if (pattern == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaTypesParams.pattern!", commandId));
        }
        return new QuteJavaTypesParams(pattern, projectUri);
    }

    private static Location getJavaDefinition(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        QuteJavaDefinitionParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteJavaDefinitionParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().getJavaDefinition(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteJavaDefinitionParams createQuteJavaDefinitionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteJavaDefinitionParams argument!", commandId));
        }
        String templateFileUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (templateFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaDefinitionParams.projectUri !", commandId));
        }
        String sourceType = ArgumentUtils.getString(obj, SOURCE_TYPE_ATTR);
        if (sourceType == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaDefinitionParams.sourceType!", commandId));
        }
        QuteJavaDefinitionParams params = new QuteJavaDefinitionParams(sourceType, templateFileUri);
        String sourceField = ArgumentUtils.getString(obj, SOURCE_FIELD_ATTR);
        params.setSourceField(sourceField);
        String sourceMethod = ArgumentUtils.getString(obj, SOURCE_METHOD_ATTR);
        params.setSourceMethod(sourceMethod);
        String methodParameter = ArgumentUtils.getString(obj, SOURCE_PARAMETER_ATTR);
        params.setSourceParameter(methodParameter);
        boolean dataMethodInvocation = ArgumentUtils.getBoolean(obj, DATA_METHOD_INVOCATION_ATTR);
        params.setDataMethodInvocation(dataMethodInvocation);
        return params;
    }

    private static WorkspaceEdit generateMissingJavaMember(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        GenerateMissingJavaMemberParams params = QuteSupportForTemplateDelegateCommandHandler.createGenerateMissingJavaMemberParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().generateMissingJavaMember(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static GenerateMissingJavaMemberParams createGenerateMissingJavaMemberParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one GenerateMissingJavaMemberParams argument!", commandId));
        }
        GenerateMissingJavaMemberParams.MemberType memberType = null;
        try {
            memberType = GenerateMissingJavaMemberParams.MemberType.forValue(ArgumentUtils.getInt(obj, "memberType"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (memberType == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required GenerateMissingJavaMemberParams.memberType !", commandId));
        }
        String missingProperty = ArgumentUtils.getString(obj, "missingProperty");
        if (missingProperty == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required GenerateMissingJavaMemberParams.missingProperty !", commandId));
        }
        String javaType = ArgumentUtils.getString(obj, "javaType");
        if (javaType == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required GenerateMissingJavaMemberParams.javaType !", commandId));
        }
        String projectUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (projectUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required GenerateMissingJavaMemberParams.projectUri !", commandId));
        }
        String templateClass = ArgumentUtils.getString(obj, "templateClass");
        if (templateClass == null && memberType == GenerateMissingJavaMemberParams.MemberType.AppendTemplateExtension) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required GenerateMissingJavaMemberParams.templateClass when memberType == memberType.AppendTemplateExtension !", commandId));
        }
        return new GenerateMissingJavaMemberParams(memberType, missingProperty, javaType, projectUri, templateClass);
    }

    private static String getJavadoc(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        QuteJavadocParams quteJavadocParams = QuteSupportForTemplateDelegateCommandHandler.createQuteJavadocParams(arguments, commandId);
        return QuteSupportForTemplate.getInstance().getJavadoc(quteJavadocParams, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteJavadocParams createQuteJavadocParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteJavadocParams argument!", commandId));
        }
        String sourceType = ArgumentUtils.getString(obj, SOURCE_TYPE_ATTR);
        if (sourceType == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavadocParams.sourceType !", commandId));
        }
        String projectUri = ArgumentUtils.getString(obj, PROJECT_URI_ATTR);
        if (projectUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavadocParams.projectUri !", commandId));
        }
        String memberName = ArgumentUtils.getString(obj, "memberName");
        if (memberName == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavadocParams.memberName !", commandId));
        }
        String signature = ArgumentUtils.getString(obj, "signature");
        if (signature == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavadocParams.signature !", commandId));
        }
        DocumentFormat documentFormat = null;
        try {
            documentFormat = DocumentFormat.forValue(ArgumentUtils.getInt(obj, "documentFormat"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (documentFormat == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavadocParams.documentFormat !", commandId));
        }
        return new QuteJavadocParams(sourceType, projectUri, memberName, signature, documentFormat);
    }

    private static boolean isInTemplate(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        QuteProjectParams params = QuteSupportForTemplateDelegateCommandHandler.createQuteProjectParams(arguments, commandId);
        ProjectInfo projectInfo = QuteSupportForTemplate.getInstance().getProjectInfo(params, JDTUtilsLSImpl.getInstance(), monitor);
        if (projectInfo == null) {
            return false;
        }
        Path templatePath = FileUtils.createPath(params.getTemplateFileUri());
        for (TemplateRootPath rootPath : projectInfo.getTemplateRootPaths()) {
            if (!rootPath.isIncluded(templatePath)) continue;
            return true;
        }
        return false;
    }
}

