/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.ls;

import com.redhat.qute.commons.QuteJavaCodeLensParams;
import com.redhat.qute.commons.QuteJavaDiagnosticsParams;
import com.redhat.qute.commons.QuteJavaDocumentLinkParams;
import com.redhat.qute.jdt.QuteSupportForJava;
import com.redhat.qute.jdt.internal.ls.AbstractQuteDelegateCommandHandler;
import com.redhat.qute.jdt.internal.ls.ArgumentUtils;
import com.redhat.qute.jdt.internal.ls.JDTUtilsLSImpl;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public class QuteSupportForJavaDelegateCommandHandler
extends AbstractQuteDelegateCommandHandler {
    private static final String QUTE_JAVA_CODELENS_COMMAND_ID = "qute/java/codeLens";
    private static final String QUTE_JAVA_DIAGNOSTICS_COMMAND_ID = "qute/java/diagnostics";
    private static final String QUTE_JAVA_DOCUMENT_LINK_COMMAND_ID = "qute/java/documentLink";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        switch (commandId) {
            case "qute/java/codeLens": {
                return QuteSupportForJavaDelegateCommandHandler.getCodeLensForJava(arguments, commandId, monitor);
            }
            case "qute/java/diagnostics": {
                return QuteSupportForJavaDelegateCommandHandler.getDiagnosticsForJava(arguments, commandId, monitor);
            }
            case "qute/java/documentLink": {
                return QuteSupportForJavaDelegateCommandHandler.getDocumentLinkForJava(arguments, commandId, monitor);
            }
        }
        return null;
    }

    private static List<? extends CodeLens> getCodeLensForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        QuteJavaCodeLensParams params = QuteSupportForJavaDelegateCommandHandler.createQuteJavaCodeLensParams(arguments, commandId);
        return QuteSupportForJava.getInstance().codeLens(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteJavaCodeLensParams createQuteJavaCodeLensParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteJavaCodeLensParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaCodeLensParams.uri (java URI)!", commandId));
        }
        return new QuteJavaCodeLensParams(javaFileUri);
    }

    private static List<PublishDiagnosticsParams> getDiagnosticsForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        QuteJavaDiagnosticsParams params = QuteSupportForJavaDelegateCommandHandler.createQuteJavaDiagnosticsParams(arguments, commandId);
        return QuteSupportForJava.getInstance().diagnostics(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteJavaDiagnosticsParams createQuteJavaDiagnosticsParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteJavaDiagnosticsParams argument!", commandId));
        }
        List<String> javaFileUris = ArgumentUtils.getStringList(obj, "uris");
        if (javaFileUris == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaDiagnosticsParams.uris (java URIs)!", commandId));
        }
        return new QuteJavaDiagnosticsParams(javaFileUris);
    }

    private static List<DocumentLink> getDocumentLinkForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        QuteJavaDocumentLinkParams params = QuteSupportForJavaDelegateCommandHandler.createQuteJavaDocumentLinkParams(arguments, commandId);
        return QuteSupportForJava.getInstance().documentLink(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static QuteJavaDocumentLinkParams createQuteJavaDocumentLinkParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one QuteJavaDocumentLinkParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required QuteJavaDocumentLinkParams.uri (java URI)!", commandId));
        }
        return new QuteJavaDocumentLinkParams(javaFileUri);
    }
}

