/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.java;

import com.redhat.qute.jdt.internal.java.AbstractQuteTemplateLinkCollector;
import com.redhat.qute.jdt.internal.java.IQuteErrorCode;
import com.redhat.qute.jdt.internal.java.QuteErrorCode;
import com.redhat.qute.jdt.utils.IJDTUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.TemplatePathInfo;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class QuteJavaDiagnosticsCollector
extends AbstractQuteTemplateLinkCollector {
    public static final String QUTE_SOURCE = "qute";
    private final List<Diagnostic> diagnostics;

    public QuteJavaDiagnosticsCollector(ITypeRoot typeRoot, List<Diagnostic> diagnostics, IJDTUtils utils, IProgressMonitor monitor) {
        super(typeRoot, utils, monitor);
        this.diagnostics = diagnostics;
    }

    @Override
    protected void collectTemplateLink(String basePath, ASTNode fieldOrMethod, ASTNode locationAnnotation, AbstractTypeDeclaration type, String className, String fieldOrMethodName, String location, IFile templateFile, TemplatePathInfo templatePathInfo) throws JavaModelException {
        QuteErrorCode error = QuteJavaDiagnosticsCollector.getQuteErrorCode(templatePathInfo, templateFile);
        if (error == null) {
            return;
        }
        String path = QuteJavaDiagnosticsCollector.createPath(basePath, className, fieldOrMethodName, location);
        String fragmentId = templatePathInfo.getFragmentId();
        if (templatePathInfo.hasFragment() && path.endsWith(fragmentId)) {
            path = path.substring(0, path.length() - (1 + fragmentId.length()));
        }
        Range range = this.createRange(locationAnnotation != null ? locationAnnotation : fieldOrMethod);
        switch (error) {
            case FragmentNotDefined: {
                Diagnostic diagnostic = QuteJavaDiagnosticsCollector.createDiagnostic(range, DiagnosticSeverity.Error, error, "", path);
                this.diagnostics.add(diagnostic);
                break;
            }
            case NoMatchingTemplate: {
                ITypeBinding binding = type.resolveBinding();
                if (binding == null) break;
                String fullQualifiedName = ((IType)binding.getJavaElement()).getFullyQualifiedName();
                Diagnostic diagnostic = QuteJavaDiagnosticsCollector.createDiagnostic(range, DiagnosticSeverity.Error, error, path, fullQualifiedName);
                this.diagnostics.add(diagnostic);
            }
        }
    }

    private static QuteErrorCode getQuteErrorCode(TemplatePathInfo templatePathInfo, IFile templateFile) {
        if (!templatePathInfo.isValid()) {
            return QuteErrorCode.FragmentNotDefined;
        }
        if (!templateFile.exists()) {
            return QuteErrorCode.NoMatchingTemplate;
        }
        return null;
    }

    private static String createPath(String basePath, String className, String fieldOrMethodName, String location) {
        if (location != null) {
            return location;
        }
        StringBuilder path = new StringBuilder();
        if (basePath != null && !"<<defaulted>>".equals(basePath)) {
            JDTQuteProjectUtils.appendAndSlash(path, basePath);
        } else if (className != null) {
            JDTQuteProjectUtils.appendAndSlash(path, className);
        }
        return path.append(fieldOrMethodName).toString();
    }

    private static Diagnostic createDiagnostic(Range range, DiagnosticSeverity severity, IQuteErrorCode errorCode, Object ... arguments) {
        String message = errorCode.getMessage(arguments);
        return new Diagnostic(range, message, severity, QUTE_SOURCE, errorCode.getCode());
    }
}

