/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.java;

import com.redhat.qute.jdt.internal.AnnotationLocationSupport;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.IJDTUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import com.redhat.qute.jdt.utils.TemplateNameStrategy;
import com.redhat.qute.jdt.utils.TemplatePathInfo;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.lsp4j.Range;

public abstract class AbstractQuteTemplateLinkCollector
extends ASTVisitor {
    private static final Logger LOGGER = Logger.getLogger(AbstractQuteTemplateLinkCollector.class.getName());
    private static String[] suffixes = new String[]{".qute.html", ".qute.json", ".qute.txt", ".qute.yaml", ".html", ".json", ".txt", ".yaml"};
    private static final String PREFERRED_SUFFIX = ".html";
    protected final ITypeRoot typeRoot;
    protected final IJDTUtils utils;
    protected final IProgressMonitor monitor;
    private int levelTypeDecl;
    private AnnotationLocationSupport annotationLocationSupport;
    private CompilationUnit compilationUnit;

    public AbstractQuteTemplateLinkCollector(ITypeRoot typeRoot, IJDTUtils utils, IProgressMonitor monitor) {
        this.typeRoot = typeRoot;
        this.utils = utils;
        this.monitor = monitor;
        this.levelTypeDecl = 0;
    }

    public boolean visit(CompilationUnit node) {
        this.compilationUnit = node;
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        Type type = node.getType();
        if (AbstractQuteTemplateLinkCollector.isTemplateType(type)) {
            StringLiteral locationExpression = AnnotationLocationSupport.getLocationExpression((ASTNode)node, node.modifiers());
            List fragments = node.fragments();
            if (fragments != null && !fragments.isEmpty()) {
                VariableDeclaration variable = (VariableDeclaration)fragments.get(0);
                if (locationExpression == null) {
                    locationExpression = this.getAnnotationLocationSupport().getLocationExpressionFromConstructorParameter(variable.getName().getIdentifier());
                }
                String fieldName = variable.getName().getIdentifier();
                this.collectTemplateLink(null, (ASTNode)node, locationExpression, (AbstractTypeDeclaration)AbstractQuteTemplateLinkCollector.getTypeDeclaration((ASTNode)node), null, fieldName, false, TemplateNameStrategy.ELEMENT_NAME);
            }
        }
        return super.visit(node);
    }

    private AnnotationLocationSupport getAnnotationLocationSupport() {
        if (this.annotationLocationSupport == null) {
            this.annotationLocationSupport = new AnnotationLocationSupport(this.compilationUnit);
        }
        return this.annotationLocationSupport;
    }

    public boolean visit(TypeDeclaration node) {
        ++this.levelTypeDecl;
        Annotation checkedAnnotation = AbstractQuteTemplateLinkCollector.getCheckedAnnotation((BodyDeclaration)node);
        if (checkedAnnotation != null) {
            boolean ignoreFragments = AbstractQuteTemplateLinkCollector.isIgnoreFragments(checkedAnnotation);
            String basePath = AbstractQuteTemplateLinkCollector.getBasePath(checkedAnnotation);
            TemplateNameStrategy templateNameStrategy = AbstractQuteTemplateLinkCollector.getDefaultName(checkedAnnotation);
            List body = node.bodyDeclarations();
            for (Object declaration : body) {
                if (!(declaration instanceof MethodDeclaration)) continue;
                MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
                String methodName = methodDeclaration.getName().getIdentifier();
                this.collectTemplateLinkForMethodOrRecord(basePath, (ASTNode)methodDeclaration, methodName, (AbstractTypeDeclaration)node, ignoreFragments, templateNameStrategy);
            }
        }
        return super.visit(node);
    }

    public boolean visit(RecordDeclaration node) {
        if (AbstractQuteTemplateLinkCollector.isImplementTemplateInstance(node)) {
            String recordName = node.getName().getIdentifier();
            Annotation checkedAnnotation = AbstractQuteTemplateLinkCollector.getCheckedAnnotation((BodyDeclaration)node);
            boolean ignoreFragments = AbstractQuteTemplateLinkCollector.isIgnoreFragments(checkedAnnotation);
            String basePath = AbstractQuteTemplateLinkCollector.getBasePath(checkedAnnotation);
            TemplateNameStrategy templateNameStrategy = AbstractQuteTemplateLinkCollector.getDefaultName(checkedAnnotation);
            this.collectTemplateLinkForMethodOrRecord(basePath, (ASTNode)node, recordName, (AbstractTypeDeclaration)node, ignoreFragments, templateNameStrategy);
        }
        return super.visit(node);
    }

    private static boolean isImplementTemplateInstance(RecordDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding == null) {
            return false;
        }
        ITypeBinding[] interfaces = binding.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding current = iTypeBindingArray[n2];
            if ("io.quarkus.qute.TemplateInstance".equals(current.getQualifiedName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Annotation getCheckedAnnotation(BodyDeclaration node) {
        List modifiers = node.modifiers();
        for (Object modifier : modifiers) {
            Annotation annotation;
            if (!(modifier instanceof Annotation) || !AnnotationUtils.isMatchAnnotation(annotation = (Annotation)modifier, "io.quarkus.qute.CheckedTemplate") && !AnnotationUtils.isMatchAnnotation(annotation, "io.quarkus.qute.api.CheckedTemplate")) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isIgnoreFragments(Annotation checkedTemplateAnnotation) {
        Boolean ignoreFragment = null;
        if (checkedTemplateAnnotation != null) {
            try {
                Expression ignoreFragmentExpr = AnnotationUtils.getAnnotationMemberValueExpression(checkedTemplateAnnotation, "ignoreFragments");
                ignoreFragment = AnnotationUtils.getBoolean(ignoreFragmentExpr);
            }
            catch (Exception exception) {}
        }
        return ignoreFragment != null ? ignoreFragment : false;
    }

    private static String getBasePath(Annotation checkedTemplateAnnotation) {
        String basePath = null;
        if (checkedTemplateAnnotation != null) {
            try {
                Expression basePathExpr = AnnotationUtils.getAnnotationMemberValueExpression(checkedTemplateAnnotation, "basePath");
                basePath = AnnotationUtils.getString(basePathExpr);
            }
            catch (Exception exception) {}
        }
        return basePath;
    }

    private static TemplateNameStrategy getDefaultName(Annotation checkedTemplateAnnotation) {
        TemplateNameStrategy defaultName = TemplateNameStrategy.ELEMENT_NAME;
        if (checkedTemplateAnnotation != null) {
            try {
                Expression defaultNameExpr = AnnotationUtils.getAnnotationMemberValueExpression(checkedTemplateAnnotation, "defaultName");
                defaultName = AbstractQuteTemplateLinkCollector.getDefaultName(AnnotationUtils.getString(defaultNameExpr));
            }
            catch (Exception exception) {}
        }
        return defaultName;
    }

    private static TemplateNameStrategy getDefaultName(String defaultName) {
        switch (defaultName) {
            case "<<hyphenated element name>>": {
                return TemplateNameStrategy.HYPHENATED_ELEMENT_NAME;
            }
            case "<<underscored element name>>": {
                return TemplateNameStrategy.UNDERSCORED_ELEMENT_NAME;
            }
        }
        return TemplateNameStrategy.ELEMENT_NAME;
    }

    public void endVisit(TypeDeclaration node) {
        --this.levelTypeDecl;
        super.endVisit(node);
    }

    private static TypeDeclaration getTypeDeclaration(ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent != null && parent.getNodeType() != 55) {
            parent = parent.getParent();
        }
        return parent != null && parent.getNodeType() == 55 ? (TypeDeclaration)parent : null;
    }

    private void collectTemplateLinkForMethodOrRecord(String basePath, ASTNode methodOrRecord, String methodOrRecordName, AbstractTypeDeclaration type, boolean ignoreFragment, TemplateNameStrategy templateNameStrategy) {
        boolean innerClass;
        String className = null;
        boolean bl = methodOrRecord instanceof RecordDeclaration ? this.levelTypeDecl >= 1 : (innerClass = this.levelTypeDecl > 1);
        if (innerClass) {
            className = JDTTypeUtils.getSimpleClassName(this.typeRoot.getElementName());
        }
        this.collectTemplateLink(basePath, methodOrRecord, null, type, className, methodOrRecordName, ignoreFragment, templateNameStrategy);
    }

    private void collectTemplateLink(String basePath, ASTNode fieldOrMethod, StringLiteral locationAnnotation, AbstractTypeDeclaration type, String className, String fieldOrMethodName, boolean ignoreFragment, TemplateNameStrategy templateNameStrategy) {
        try {
            String location = locationAnnotation != null ? locationAnnotation.getLiteralValue() : null;
            IProject project = this.typeRoot.getJavaProject().getProject();
            TemplatePathInfo templatePathInfo = location != null ? JDTQuteProjectUtils.getTemplatePath(basePath, null, location, ignoreFragment, templateNameStrategy) : JDTQuteProjectUtils.getTemplatePath(basePath, className, fieldOrMethodName, ignoreFragment, templateNameStrategy);
            IFile templateFile = null;
            if (location == null) {
                templateFile = AbstractQuteTemplateLinkCollector.getTemplateFile(project, templatePathInfo.getTemplateUri());
                templatePathInfo = new TemplatePathInfo(templateFile.getLocation().makeRelativeTo(project.getLocation()).toString(), templatePathInfo.getFragmentId());
            } else {
                templateFile = project.getFile(templatePathInfo.getTemplateUri());
            }
            this.collectTemplateLink(basePath, fieldOrMethod, (ASTNode)locationAnnotation, type, className, fieldOrMethodName, location, templateFile, templatePathInfo);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while creating Qute CodeLens for Java file.", e);
        }
    }

    protected Range createRange(ASTNode fieldOrMethod) throws JavaModelException {
        switch (fieldOrMethod.getNodeType()) {
            case 23: {
                FieldDeclaration field = (FieldDeclaration)fieldOrMethod;
                if (!field.fragments().isEmpty()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
                    return this.utils.toRange((IOpenable)this.typeRoot, fragment.getStartPosition(), fragment.getLength());
                }
                return this.utils.toRange((IOpenable)this.typeRoot, field.getStartPosition(), field.getLength());
            }
            case 31: {
                MethodDeclaration method = (MethodDeclaration)fieldOrMethod;
                SimpleName methodName = method.getName();
                return this.utils.toRange((IOpenable)this.typeRoot, methodName.getStartPosition(), methodName.getLength());
            }
            case 103: {
                RecordDeclaration recordDecl = (RecordDeclaration)fieldOrMethod;
                SimpleName recordName = recordDecl.getName();
                return this.utils.toRange((IOpenable)this.typeRoot, recordName.getStartPosition(), recordName.getLength());
            }
        }
        return this.utils.toRange((IOpenable)this.typeRoot, fieldOrMethod.getStartPosition(), fieldOrMethod.getLength());
    }

    protected abstract void collectTemplateLink(String var1, ASTNode var2, ASTNode var3, AbstractTypeDeclaration var4, String var5, String var6, String var7, IFile var8, TemplatePathInfo var9) throws JavaModelException;

    private static IFile getTemplateFile(IProject project, String templateFilePathWithoutExtension) {
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            IFile templateFile = project.getFile(templateFilePathWithoutExtension + suffix);
            if (templateFile.exists()) {
                return templateFile;
            }
            ++n2;
        }
        return project.getFile(templateFilePathWithoutExtension + PREFERRED_SUFFIX);
    }

    private static boolean isTemplateType(Type type) {
        if (type == null || !type.isSimpleType()) {
            return false;
        }
        ITypeBinding binding = ((SimpleType)type).resolveBinding();
        if (binding == null) {
            return false;
        }
        return "io.quarkus.qute.Template".equals(binding.getQualifiedName());
    }
}

