/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.extensions.roq;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class DataMappingSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(DataMappingSupport.class.getName());
    private static final String INJECT_NAMESPACE = "inject";
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkiverse.roq.data.runtime.annotations.DataMapping"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() != 7) {
            return;
        }
        IType type = (IType)javaElement;
        String value = DataMappingSupport.getDataMappingAnnotationValue((IJavaElement)type);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
            DataMappingSupport.collectResolversForInject(type, value, context.getDataModelProject().getValueResolvers());
        }
    }

    private static String getDataMappingAnnotationValue(IJavaElement javaElement) {
        try {
            IAnnotation namedAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)javaElement, "io.quarkiverse.roq.data.runtime.annotations.DataMapping");
            if (namedAnnotation != null) {
                return AnnotationUtils.getAnnotationMemberValue(namedAnnotation, "value");
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting @DataMapping annotation value.", e);
            return null;
        }
        return null;
    }

    private static void collectResolversForInject(IType type, String named, List<ValueResolverInfo> resolvers) {
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setNamed(named);
        resolver.setSourceType(type.getFullyQualifiedName());
        resolver.setSignature(type.getFullyQualifiedName());
        resolver.setNamespace(INJECT_NAMESPACE);
        resolver.setKind(ValueResolverKind.InjectedBean);
        resolvers.add(resolver);
    }
}

