/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.extensions.renarde;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.template.datamodel.AbstractDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;

public class UriNamespaceResolverSupport
extends AbstractDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(UriNamespaceResolverSupport.class.getName());
    private static final String URI_NAMESPACE = "uri";
    private static final String URIABS_NAMESPACE = "uriabs";

    @Override
    public void beginSearch(SearchContext context, IProgressMonitor monitor) {
        IJavaProject javaProject = context.getJavaProject();
        IType type = JDTTypeUtils.findType(javaProject, "io.quarkiverse.renarde.Controller");
        if (type != null) {
            try {
                this.collectRenardeController(type, context, monitor);
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.SEVERE, "Error while collecting Renarde Controller.", e);
            }
        }
    }

    public void collectRenardeController(IType type, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (type == null) {
            return;
        }
        ITypeHierarchy typeHierarchy = type.newTypeHierarchy(monitor);
        IType[] controllerTypes = typeHierarchy.getAllSubtypes(type);
        List<ValueResolverInfo> resolvers = context.getDataModelProject().getValueResolvers();
        IType[] iTypeArray = controllerTypes;
        int n = controllerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType controllerType = iTypeArray[n2];
            if (UriNamespaceResolverSupport.isRenardeController(controllerType)) {
                UriNamespaceResolverSupport.addRenardeController(URI_NAMESPACE, controllerType, resolvers);
                UriNamespaceResolverSupport.addRenardeController(URIABS_NAMESPACE, controllerType, resolvers);
            }
            ++n2;
        }
    }

    private static boolean isRenardeController(IType controllerType) throws JavaModelException {
        if (Flags.isAbstract((int)controllerType.getFlags())) {
            return false;
        }
        String typeName = controllerType.getFullyQualifiedName();
        return !"java.lang.Object".equals(typeName) && !"io.quarkiverse.renarde.Controller".equals(typeName);
    }

    private static void addRenardeController(String namespace, IType controllerType, List<ValueResolverInfo> resolvers) {
        String className = controllerType.getFullyQualifiedName();
        String named = controllerType.getElementName();
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setNamed(named);
        resolver.setSourceType(className);
        resolver.setSignature(className);
        resolver.setNamespace(namespace);
        resolver.setKind(ValueResolverKind.Renarde);
        if (!resolvers.contains(resolver)) {
            resolvers.add(resolver);
        }
    }

    @Override
    protected boolean isNamespaceAvailable(String namespace, SearchContext context, IProgressMonitor monitor) {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "io.quarkiverse.renarde.Controller") != null;
    }

    @Override
    public void collectDataModel(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
    }

    @Override
    protected String[] getPatterns() {
        return null;
    }

    @Override
    protected SearchPattern createSearchPattern(String pattern) {
        return null;
    }
}

