/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.extensions.quarkus;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.CDIUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class InjectNamespaceResolverSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(InjectNamespaceResolverSupport.class.getName());
    private static final String INJECT_NAMESPACE = "inject";
    private static final String[] ANNOTATION_NAMES = new String[]{"javax.inject.Named", "jakarta.inject.Named"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 7: {
                IType type = (IType)javaElement;
                String named = InjectNamespaceResolverSupport.getNamed((IJavaElement)type);
                if (!CDIUtils.isValidBean(javaElement)) break;
                InjectNamespaceResolverSupport.collectResolversForInject(type, named, context.getDataModelProject().getValueResolvers());
                break;
            }
            case 8: 
            case 9: {
                IMember javaMember = (IMember)javaElement;
                String named = InjectNamespaceResolverSupport.getNamed((IJavaElement)javaMember);
                ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver(javaMember);
                InjectNamespaceResolverSupport.collectResolversForInject(javaMember, named, context.getDataModelProject().getValueResolvers(), typeResolver);
            }
        }
    }

    private static String getNamed(IJavaElement javaElement) {
        String named = InjectNamespaceResolverSupport.getAnnotationNamedValue(javaElement);
        return CDIUtils.getSimpleName(javaElement, named);
    }

    private static String getAnnotationNamedValue(IJavaElement javaElement) {
        try {
            IAnnotation namedAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)javaElement, "javax.inject.Named", "jakarta.inject.Named");
            if (namedAnnotation != null) {
                return AnnotationUtils.getAnnotationMemberValue(namedAnnotation, "value");
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting @Named annotation value.", e);
            return null;
        }
        return null;
    }

    private static void collectResolversForInject(IType type, String named, List<ValueResolverInfo> resolvers) {
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setNamed(named);
        resolver.setSourceType(type.getFullyQualifiedName());
        resolver.setSignature(type.getFullyQualifiedName());
        resolver.setNamespace(INJECT_NAMESPACE);
        resolver.setKind(ValueResolverKind.InjectedBean);
        resolvers.add(resolver);
    }

    private static void collectResolversForInject(IMember javaMember, String named, List<ValueResolverInfo> resolvers, ITypeResolver typeResolver) {
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setNamed(named);
        resolver.setSourceType(javaMember.getDeclaringType().getFullyQualifiedName());
        resolver.setSignature(typeResolver.resolveSignature((IJavaElement)javaMember));
        resolver.setNamespace(INJECT_NAMESPACE);
        resolver.setKind(ValueResolverKind.InjectedBean);
        resolvers.add(resolver);
    }
}

