/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal;

import com.redhat.qute.commons.datamodel.JavaDataModelChangeEvent;
import com.redhat.qute.jdt.IJavaDataModelChangedListener;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class JavaDataModelListenerManager {
    private static final Logger LOGGER = Logger.getLogger(JavaDataModelListenerManager.class.getName());
    private static final JavaDataModelListenerManager INSTANCE = new JavaDataModelListenerManager();
    private QuteListener quteListener;
    private final Set<IJavaDataModelChangedListener> listeners = new HashSet<IJavaDataModelChangedListener>();

    public static JavaDataModelListenerManager getInstance() {
        return INSTANCE;
    }

    private JavaDataModelListenerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaDataModelChangedListener(IJavaDataModelChangedListener listener) {
        Set<IJavaDataModelChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJavaDataModelChangedListener(IJavaDataModelChangedListener listener) {
        Set<IJavaDataModelChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void initialize() {
        if (this.quteListener != null) {
            return;
        }
        this.quteListener = new QuteListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.quteListener);
    }

    public synchronized void destroy() {
        if (this.quteListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.quteListener);
            this.quteListener = null;
        }
    }

    private class QuteListener
    implements IElementChangedListener {
        private QuteListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (JavaDataModelListenerManager.this.listeners.isEmpty()) {
                return;
            }
            HashMap<IJavaProject, JavaDataModelChangeEvent.ProjectChangeInfo> changedProjects = new HashMap<IJavaProject, JavaDataModelChangeEvent.ProjectChangeInfo>();
            this.processDelta(event.getDelta(), changedProjects);
            if (changedProjects.isEmpty()) {
                return;
            }
            JavaDataModelChangeEvent mpEvent = new JavaDataModelChangeEvent();
            mpEvent.setProjects(new HashSet<JavaDataModelChangeEvent.ProjectChangeInfo>(changedProjects.values()));
            this.fireAsyncEvent(mpEvent);
        }

        private void processDelta(IJavaElementDelta delta, Map<IJavaProject, JavaDataModelChangeEvent.ProjectChangeInfo> changedProjects) {
            IJavaElement element = delta.getElement();
            switch (element.getElementType()) {
                case 1: 
                case 3: 
                case 4: {
                    this.processDeltaChildren(delta, changedProjects);
                    break;
                }
                case 2: {
                    if (this.isCreatedOrDeleted(delta) || this.isClasspathChanged(delta.getFlags())) {
                        IJavaProject project = (IJavaProject)element;
                        this.getProjectInfo(project, changedProjects);
                    }
                    this.processDeltaChildren(delta, changedProjects);
                    break;
                }
                case 5: {
                    if (!QuteListener.shouldReportJavaFileAsChanged(delta)) break;
                    ICompilationUnit compilationUnit = (ICompilationUnit)element;
                    String fullyQualifiedName = QuteListener.getQualifiedName(compilationUnit);
                    JavaDataModelChangeEvent.ProjectChangeInfo projectChangeInfo = this.getProjectInfo(compilationUnit.getJavaProject(), changedProjects);
                    Set<String> sources = projectChangeInfo.getSources();
                    if (sources == null) {
                        sources = new HashSet<String>();
                        projectChangeInfo.setSources(sources);
                    }
                    sources.add(fullyQualifiedName);
                    break;
                }
            }
        }

        private static boolean shouldReportJavaFileAsChanged(IJavaElementDelta delta) {
            boolean javaFileSaved;
            boolean javaFileDeleted;
            boolean javaFileCreated;
            boolean bl = javaFileCreated = delta.getFlags() == 0 && delta.getKind() == 1;
            if (javaFileCreated) {
                return true;
            }
            boolean bl2 = javaFileDeleted = delta.getFlags() == 0 && delta.getKind() == 2;
            if (javaFileDeleted) {
                return true;
            }
            boolean bl3 = javaFileSaved = (delta.getFlags() & 0x40000) != 0;
            return javaFileSaved;
        }

        private void processDeltaChildren(IJavaElementDelta delta, Map<IJavaProject, JavaDataModelChangeEvent.ProjectChangeInfo> changedProjects) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta c = iJavaElementDeltaArray[n2];
                this.processDelta(c, changedProjects);
                ++n2;
            }
        }

        private static String getQualifiedName(ICompilationUnit cu) {
            String typeName;
            String packageName = "";
            if (cu.getParent() instanceof IPackageFragment) {
                packageName = ((IPackageFragment)cu.getParent()).getElementName();
            }
            if ((typeName = cu.getElementName()).endsWith(".java")) {
                typeName = typeName.substring(0, typeName.length() - ".java".length());
            }
            return packageName.isEmpty() ? typeName : packageName + "." + typeName;
        }

        private JavaDataModelChangeEvent.ProjectChangeInfo getProjectInfo(IJavaProject project, Map<IJavaProject, JavaDataModelChangeEvent.ProjectChangeInfo> changedProjects) {
            JavaDataModelChangeEvent.ProjectChangeInfo projectInfo = changedProjects.get(project);
            if (projectInfo == null) {
                projectInfo = new JavaDataModelChangeEvent.ProjectChangeInfo(JDTQuteProjectUtils.getProjectUri(project));
                changedProjects.put(project, projectInfo);
            }
            return projectInfo;
        }

        private boolean isCreatedOrDeleted(IJavaElementDelta delta) {
            int kind = delta.getKind();
            return kind == 1 || kind == 2;
        }

        private boolean isClasspathChanged(int flags) {
            return (flags & 0x220600) != 0;
        }

        private void fireAsyncEvent(JavaDataModelChangeEvent event) {
            CompletableFuture.runAsync(() -> {
                for (IJavaDataModelChangedListener listener : JavaDataModelListenerManager.this.listeners) {
                    try {
                        listener.dataModelChanged(event);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Error while sending LSP 'qute/javaDataModelChanged' notification", e);
                    }
                }
            });
        }
    }
}

