/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal;

import com.redhat.qute.jdt.utils.AnnotationUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;

public class AnnotationLocationSupport
extends ASTVisitor {
    private final Map<String, SingleVariableDeclaration> assignedFields = new HashMap<String, SingleVariableDeclaration>();
    private Set<SingleVariableDeclaration> constructorParametersAnnotatedWithLocation;

    public AnnotationLocationSupport(CompilationUnit root) {
        root.accept((ASTVisitor)this);
    }

    public boolean visit(MethodDeclaration node) {
        boolean visitBody = false;
        if (node.isConstructor()) {
            List parameters = node.parameters();
            for (Object parameter : parameters) {
                SingleVariableDeclaration variable;
                if (!(parameter instanceof SingleVariableDeclaration) || AnnotationLocationSupport.getLocationExpression((ASTNode)(variable = (SingleVariableDeclaration)parameter), variable.modifiers()) == null) continue;
                if (this.constructorParametersAnnotatedWithLocation == null) {
                    this.constructorParametersAnnotatedWithLocation = new HashSet<SingleVariableDeclaration>();
                }
                this.constructorParametersAnnotatedWithLocation.add(variable);
                visitBody = true;
            }
        }
        return visitBody;
    }

    public boolean visit(Assignment node) {
        MethodInvocation methodInvocation;
        SingleVariableDeclaration variable;
        FieldAccess fieldAccess;
        Expression left = node.getLeftHandSide();
        Expression right = node.getRightHandSide();
        if (left == null || right == null) {
            return false;
        }
        FieldAccess fieldAccess2 = fieldAccess = left instanceof FieldAccess ? (FieldAccess)left : null;
        if (fieldAccess == null) {
            return false;
        }
        if (right instanceof SimpleName) {
            SingleVariableDeclaration variable2 = AnnotationLocationSupport.getMatchedParameter((SimpleName)right, this.constructorParametersAnnotatedWithLocation);
            if (variable2 != null) {
                this.assignedFields.put(fieldAccess.getName().getIdentifier(), variable2);
            }
        } else if (right instanceof MethodInvocation && (variable = AnnotationLocationSupport.getMatchedParameter(methodInvocation = (MethodInvocation)right, this.constructorParametersAnnotatedWithLocation)) != null) {
            this.assignedFields.put(fieldAccess.getName().getIdentifier(), variable);
        }
        return super.visit(node);
    }

    private static SingleVariableDeclaration getMatchedParameter(SimpleName simpleName, Set<SingleVariableDeclaration> constructorParametersAnnotatedWithLocation) {
        String name = simpleName.getIdentifier();
        for (SingleVariableDeclaration variable : constructorParametersAnnotatedWithLocation) {
            if (!variable.getName().getIdentifier().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private static SingleVariableDeclaration getMatchedParameter(MethodInvocation methodInvocation, Set<SingleVariableDeclaration> constructorParametersAnnotatedWithLocation) {
        for (Object arg : methodInvocation.arguments()) {
            SingleVariableDeclaration variable;
            if (!(arg instanceof SimpleName) || (variable = AnnotationLocationSupport.getMatchedParameter((SimpleName)arg, constructorParametersAnnotatedWithLocation)) == null) continue;
            return variable;
        }
        return null;
    }

    public StringLiteral getLocationExpressionFromConstructorParameter(String fieldName) {
        SingleVariableDeclaration variable = this.assignedFields.get(fieldName);
        if (variable == null) {
            return null;
        }
        return AnnotationLocationSupport.getLocationExpression((ASTNode)variable, variable.modifiers());
    }

    public static StringLiteral getLocationExpression(ASTNode node, List modifiers) {
        if (modifiers == null || modifiers.isEmpty()) {
            return null;
        }
        for (Object modifier : modifiers) {
            String location;
            Expression expression;
            SingleMemberAnnotation annotation;
            if (!(modifier instanceof SingleMemberAnnotation) || !AnnotationUtils.isMatchAnnotation((Annotation)(annotation = (SingleMemberAnnotation)modifier), "io.quarkus.qute.Location") || (expression = annotation.getValue()) == null || !(expression instanceof StringLiteral) || !StringUtils.isNotBlank((CharSequence)(location = ((StringLiteral)expression).getLiteralValue()))) continue;
            return (StringLiteral)expression;
        }
        return null;
    }
}

