/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt;

import com.redhat.qute.commons.DocumentFormat;
import com.redhat.qute.commons.GenerateMissingJavaMemberParams;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.QuteJavaTypesParams;
import com.redhat.qute.commons.QuteJavadocParams;
import com.redhat.qute.commons.QuteProjectParams;
import com.redhat.qute.commons.QuteResolvedJavaTypeParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.QuteDataModelProjectParams;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.commons.usertags.QuteUserTagParams;
import com.redhat.qute.commons.usertags.UserTagInfo;
import com.redhat.qute.jdt.internal.resolver.AbstractTypeResolver;
import com.redhat.qute.jdt.internal.resolver.ClassFileTypeResolver;
import com.redhat.qute.jdt.internal.resolver.CompilationUnitTypeResolver;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.internal.template.JavaTypesSearch;
import com.redhat.qute.jdt.internal.template.QuarkusIntegrationForQute;
import com.redhat.qute.jdt.internal.template.TemplateDataSupport;
import com.redhat.qute.jdt.internal.template.TemplateGenerateMissingJavaMember;
import com.redhat.qute.jdt.internal.template.resolvedtype.ResolvedJavaTypeFactoryRegistry;
import com.redhat.qute.jdt.utils.IJDTUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.WorkspaceEdit;

public class QuteSupportForTemplate {
    private static final Logger LOGGER = Logger.getLogger(QuteSupportForTemplate.class.getName());
    private static final QuteSupportForTemplate INSTANCE = new QuteSupportForTemplate();

    public static QuteSupportForTemplate getInstance() {
        return INSTANCE;
    }

    public List<ProjectInfo> getProjects(IJDTUtils utils, IProgressMonitor monitor) {
        IProject[] allProjects;
        ArrayList<ProjectInfo> quteProjects = new ArrayList<ProjectInfo>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IJavaProject javaProject = QuteSupportForTemplate.getJavaProject(project);
            if (QuteSupportForTemplate.isQuteProject(javaProject)) {
                quteProjects.add(JDTQuteProjectUtils.getProjectInfo(javaProject));
            }
            ++n2;
        }
        return quteProjects;
    }

    public ProjectInfo getProjectInfo(QuteProjectParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IJavaProject javaProject = QuteSupportForTemplate.findJavaProject(params.getTemplateFileUri(), utils);
        if (javaProject == null) {
            return null;
        }
        return JDTQuteProjectUtils.getProjectInfo(javaProject);
    }

    public DataModelProject<DataModelTemplate<DataModelParameter>> getDataModelProject(QuteDataModelProjectParams params, IJDTUtils utils, IProgressMonitor monitor) throws CoreException {
        String projectUri = params.getProjectUri();
        IJavaProject javaProject = QuteSupportForTemplate.getJavaProjectFromProjectUri(projectUri);
        if (javaProject == null) {
            return null;
        }
        return QuarkusIntegrationForQute.getDataModelProject(javaProject, monitor);
    }

    public List<UserTagInfo> getUserTags(QuteUserTagParams params, IJDTUtils utils, IProgressMonitor monitor) throws CoreException {
        String projectUri = params.getProjectUri();
        IJavaProject javaProject = QuteSupportForTemplate.getJavaProjectFromProjectUri(projectUri);
        if (javaProject == null) {
            return null;
        }
        return QuarkusIntegrationForQute.getUserTags(javaProject, monitor);
    }

    public List<JavaTypeInfo> getJavaTypes(QuteJavaTypesParams params, IJDTUtils utils, IProgressMonitor monitor) throws CoreException {
        String projectUri = params.getProjectUri();
        IJavaProject javaProject = QuteSupportForTemplate.getJavaProjectFromProjectUri(projectUri);
        if (javaProject == null) {
            return null;
        }
        return new JavaTypesSearch(params.getPattern(), javaProject).search(monitor);
    }

    public Location getJavaDefinition(QuteJavaDefinitionParams params, IJDTUtils utils, IProgressMonitor monitor) throws CoreException {
        boolean dataMethodInvocation;
        IType type = this.getTypeFromParams(params.getSourceType(), params.getProjectUri(), monitor);
        if (type == null) {
            return null;
        }
        String parameterName = params.getSourceParameter();
        String fieldName = params.getSourceField();
        boolean bl = dataMethodInvocation = parameterName != null && params.isDataMethodInvocation();
        if (type.isRecord()) {
            IField recordField;
            String recordFieldName;
            if (dataMethodInvocation) {
                return TemplateDataSupport.getDataMethodInvocationLocation((IMember)type, parameterName, utils, monitor);
            }
            String string = recordFieldName = parameterName != null ? parameterName : fieldName;
            if (recordFieldName != null && (recordField = type.getRecordComponent(recordFieldName)) != null && recordField.exists()) {
                return utils.toLocation((IJavaElement)recordField);
            }
        } else {
            if (fieldName != null) {
                IField field = type.getField(fieldName);
                if (field == null || !field.exists()) {
                    return null;
                }
                if (dataMethodInvocation) {
                    return TemplateDataSupport.getDataMethodInvocationLocation((IMember)field, parameterName, utils, monitor);
                }
                return utils.toLocation((IJavaElement)field);
            }
            String sourceMethod = params.getSourceMethod();
            if (sourceMethod != null) {
                IMethod method = this.findMethod(type, sourceMethod);
                if (method == null || !method.exists()) {
                    return null;
                }
                if (parameterName != null) {
                    ILocalVariable[] parameters;
                    if (dataMethodInvocation) {
                        return TemplateDataSupport.getDataMethodInvocationLocation((IMember)method, parameterName, utils, monitor);
                    }
                    ILocalVariable[] iLocalVariableArray = parameters = method.getParameters();
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocalVariable parameter = iLocalVariableArray[n2];
                        if (parameterName.equals(parameter.getElementName())) {
                            return utils.toLocation((IJavaElement)parameter);
                        }
                        ++n2;
                    }
                    return null;
                }
                return utils.toLocation((IJavaElement)method);
            }
        }
        return utils.toLocation((IJavaElement)type);
    }

    private IMethod findMethod(IType type, String sourceMethod) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (sourceMethod.equals(method.getElementName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private IMethod findMethodOLD(IType type, String sourceMethod) throws JavaModelException {
        int endBracketIndex;
        String methodSignature;
        String[] paramTypes;
        int startBracketIndex = sourceMethod.indexOf(40);
        String methodName = sourceMethod.substring(0, startBracketIndex);
        IMethod method = JavaModelUtil.findMethod((String)methodName, (String[])(paramTypes = (methodSignature = sourceMethod.substring(startBracketIndex, (endBracketIndex = sourceMethod.indexOf(41)) + 1)).isEmpty() ? CharOperation.NO_STRINGS : Signature.getParameterTypes((String)methodSignature)), (boolean)false, (IType)type);
        if (method == null) {
            method = JavaModelUtil.findMethod((String)methodName, (String[])paramTypes, (boolean)true, (IType)type);
        }
        return method;
    }

    public ResolvedJavaTypeInfo getResolvedJavaType(QuteResolvedJavaTypeParams params, IJDTUtils utils, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String projectUri = params.getProjectUri();
        IJavaProject javaProject = QuteSupportForTemplate.getJavaProjectFromProjectUri(projectUri);
        if (javaProject == null) {
            return null;
        }
        String typeName = params.getClassName();
        IType type = JDTTypeUtils.findType(typeName, javaProject, monitor);
        if (type == null) {
            return null;
        }
        ValueResolverKind kind = params.getKind();
        return ResolvedJavaTypeFactoryRegistry.getInstance().create(type, kind);
    }

    private static boolean isValidField(IField field, IType type) throws JavaModelException {
        if (type.isEnum()) {
            return true;
        }
        return Flags.isPublic((int)field.getFlags());
    }

    private static IJavaProject getJavaProjectFromProjectUri(String projectName) {
        if (projectName == null) {
            return null;
        }
        JavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
        return javaProject.exists() ? javaProject : null;
    }

    private static IJavaProject findJavaProject(String resourceUri, IJDTUtils utils) {
        IProject project = QuteSupportForTemplate.findProject(resourceUri, utils);
        if (project == null) {
            return null;
        }
        return QuteSupportForTemplate.getJavaProject(project);
    }

    private static IProject findProject(String resourceUri, IJDTUtils utils) {
        String fileUri = resourceUri.replace("vscode-notebook-cell", "file");
        IFile file = utils.findFile(fileUri);
        if (file != null) {
            return file.getProject();
        }
        URI projectUri = QuteSupportForTemplate.toURI(resourceUri);
        if (!URIUtil.isFileURI((URI)projectUri)) {
            return null;
        }
        Path projectPath = Paths.get(projectUri);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject currentProject = iProjectArray[n2];
            Path currentProjectPath = Paths.get(currentProject.getLocationURI());
            if (projectPath.equals(currentProjectPath)) {
                if (!QuteSupportForTemplate.isQuteProject(currentProject)) {
                    return null;
                }
                return currentProject;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isQuteProject(IProject project) {
        IJavaProject javaProject = QuteSupportForTemplate.getJavaProject(project);
        return QuteSupportForTemplate.isQuteProject(javaProject);
    }

    private static boolean isQuteProject(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        return JDTTypeUtils.findType(javaProject, "io.quarkus.qute.Template") != null;
    }

    private static IJavaProject getJavaProject(IProject project) {
        if (!JavaProject.hasJavaNature((IProject)project)) {
            return null;
        }
        return JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject((IResource)project);
    }

    private static URI toURI(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
                uri = URIUtil.toFile((URI)uri).toURI();
            }
            return uri;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static IType[] findImplementedInterfaces(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
        return typeHierarchy.getRootInterfaces();
    }

    public static ITypeResolver createTypeResolver(IMember member) {
        AbstractTypeResolver typeResolver = !member.isBinary() ? new CompilationUnitTypeResolver((ICompilationUnit)member.getAncestor(5)) : new ClassFileTypeResolver((IClassFile)member.getAncestor(6));
        return typeResolver;
    }

    public WorkspaceEdit generateMissingJavaMember(GenerateMissingJavaMemberParams params, IJDTUtils utils, IProgressMonitor monitor) {
        return TemplateGenerateMissingJavaMember.handleGenerateMissingJavaMember(params, utils, monitor);
    }

    public String getJavadoc(QuteJavadocParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IType type;
        block3: {
            try {
                type = this.getTypeFromParams(params.getSourceType(), params.getProjectUri(), monitor);
                if (type != null) break block3;
                return null;
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.SEVERE, "Error while collecting Javadoc for " + params.getSourceType() + "#" + params.getMemberName(), e);
                return null;
            }
        }
        return this.getJavadoc(type, params.getDocumentFormat(), params.getMemberName(), params.getSignature(), utils, monitor, new HashSet<IType>());
    }

    private String getJavadoc(IType type, DocumentFormat documentFormat, String memberName, String signature, IJDTUtils utils, IProgressMonitor monitor, Set<IType> visited) throws JavaModelException {
        IMethod[] methods;
        Object javadoc;
        IField field;
        IField[] fields;
        if (visited.contains(type)) {
            return null;
        }
        visited.add(type);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)type);
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            field = iFieldArray[n2];
            if (QuteSupportForTemplate.isValidField(field, type) && memberName.equals(field.getElementName()) && signature.equals(typeResolver.resolveFieldSignature(field)) && (javadoc = utils.getJavadoc((IMember)field, documentFormat)) != null) {
                return javadoc;
            }
            ++n2;
        }
        if (type.isRecord()) {
            iFieldArray = type.getRecordComponents();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                field = iFieldArray[n2];
                if (memberName.equals(field.getElementName()) && signature.equals(typeResolver.resolveFieldSignature(field)) && (javadoc = utils.getJavadoc((IMember)field, documentFormat)) != null) {
                    return javadoc;
                }
                ++n2;
            }
        }
        javadoc = methods = type.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            IMethod method = javadoc[n];
            try {
                String javadoc2;
                if (signature.equals(typeResolver.resolveMethodSignature(method)) && (javadoc2 = utils.getJavadoc((IMember)method, documentFormat)) != null) {
                    return javadoc2;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while getting method signature of '" + method.getElementName() + "'.", e);
            }
            ++n;
        }
        List<IType> extendedTypes = null;
        if (type.isInterface()) {
            IType[] interfaces = QuteSupportForTemplate.findImplementedInterfaces(type, monitor);
            if (interfaces != null && interfaces.length > 0) {
                extendedTypes = Arrays.asList(interfaces);
            }
        } else {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(monitor);
            IType[] allSuperTypes = typeHierarchy.getSupertypes(type);
            extendedTypes = Arrays.asList(allSuperTypes);
        }
        if (extendedTypes != null) {
            for (IType extendedType : extendedTypes) {
                javadoc = this.getJavadoc(extendedType, documentFormat, memberName, signature, utils, monitor, visited);
                if (javadoc == null) continue;
                return javadoc;
            }
        }
        return null;
    }

    private IType getTypeFromParams(String typeName, String projectUri, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = QuteSupportForTemplate.getJavaProjectFromProjectUri(projectUri);
        if (javaProject == null) {
            return null;
        }
        IType type = JDTTypeUtils.findType(typeName, javaProject, monitor);
        return type;
    }
}

