/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import com.redhat.qute.commons.FileUtils;
import java.nio.file.Path;
import java.util.List;

public class TemplateRootPath {
    public static final String TAGS_DIR = "tags";
    private String baseDir;
    private String origin;
    private transient Path basePath;
    private transient Path tagsDir;
    private List<FilePath> includes;
    private List<FilePath> excludes;

    public TemplateRootPath() {
    }

    public TemplateRootPath(String baseDir) {
        this(baseDir, null);
    }

    public TemplateRootPath(String baseDir, String origin) {
        this.setBaseDir(baseDir);
        this.setOrigin(origin);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public Path getBasePath() {
        if (this.basePath == null && this.baseDir != null) {
            this.basePath = FileUtils.createPath(this.baseDir);
        }
        return this.basePath;
    }

    public Path getTagsDir() {
        if (this.tagsDir != null) {
            return this.tagsDir;
        }
        Path basePath = this.getBasePath();
        if (basePath != null) {
            this.tagsDir = basePath.resolve(TAGS_DIR);
        }
        return this.tagsDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public List<FilePath> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<FilePath> includes) {
        this.includes = includes;
    }

    public List<FilePath> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<FilePath> excludes) {
        this.excludes = excludes;
    }

    public boolean isIncluded(String uri) {
        Path path = FileUtils.createPath(uri);
        return this.isIncluded(path);
    }

    public boolean isIncluded(Path path) {
        if (path == null) {
            return false;
        }
        Path basePath = this.getBasePath();
        if (basePath == null) {
            return false;
        }
        return path.startsWith(basePath);
    }

    public static class FilePath {
        private boolean folder;
        private String path;

        public boolean isFolder() {
            return this.folder;
        }

        public void setFolder(boolean folder) {
            this.folder = folder;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

