/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import com.redhat.qute.commons.JavaElementInfo;
import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaTypeInfo;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class JavaParameterInfo
extends JavaElementInfo {
    private static final String VARARGS = "...";
    private final String name;
    private final String type;
    private transient JavaTypeInfo javaType;
    private String varArgType;

    public JavaParameterInfo(String name, String type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVarArgType() {
        if (this.varArgType == null && this.isVarargs()) {
            this.varArgType = this.type.substring(0, this.type.length() - 3);
        }
        return this.varArgType;
    }

    public boolean isVarargs() {
        return this.type.endsWith(VARARGS);
    }

    public JavaTypeInfo getJavaType() {
        if (this.javaType == null) {
            this.javaType = new JavaTypeInfo();
            this.javaType.setSignature(this.getType());
        }
        return this.javaType;
    }

    public String getSimpleParameter() {
        StringBuilder paramBuilder = new StringBuilder();
        paramBuilder.append(this.name);
        paramBuilder.append(" : ");
        paramBuilder.append(this.getJavaElementSimpleType());
        return paramBuilder.toString();
    }

    @Override
    public String getJavaElementSimpleType() {
        if (this.isVarargs()) {
            String type = this.getVarArgType();
            return JavaParameterInfo.getSimpleType(type) + VARARGS;
        }
        return super.getJavaElementSimpleType();
    }

    @Override
    public JavaElementKind getJavaElementKind() {
        return JavaElementKind.PARAMETER;
    }

    @Override
    public String getJavaElementType() {
        return this.getType();
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.getName());
        b.add("type", (Object)this.getType());
        b.add("varargs", (Object)this.isVarargs());
        b.add("signature", (Object)this.getSignature());
        return b.toString();
    }
}

