/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin.utils;

import com.microsoft.java.bs.gradle.model.Artifact;
import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.LanguageExtension;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import com.microsoft.java.bs.gradle.model.impl.DefaultArtifact;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleModuleDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSet;
import com.microsoft.java.bs.gradle.model.impl.DefaultJavaExtension;
import com.microsoft.java.bs.gradle.plugin.dependency.AndroidDependencyCollector;
import com.microsoft.java.bs.gradle.plugin.utils.SourceSetUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;

public class AndroidUtils {
    private AndroidUtils() {
    }

    public static boolean isAndroidProject(Project project) {
        return AndroidUtils.getAndroidExtension(project) != null;
    }

    public static List<GradleSourceSet> getBuildVariantsAsGradleSourceSets(Project project) {
        GradleSourceSet sourceSet;
        LinkedList<GradleSourceSet> sourceSets = new LinkedList<GradleSourceSet>();
        Object androidExtension = AndroidUtils.getAndroidExtension(project);
        if (androidExtension == null) {
            return sourceSets;
        }
        AndroidProjectType androidProjectType = AndroidUtils.getProjectType(project);
        if (androidProjectType == null) {
            return sourceSets;
        }
        List<Object> variants = new LinkedList();
        switch (androidProjectType) {
            case APPLICATION: 
            case DYNAMIC_FEATURE: {
                variants = AndroidUtils.getVariants(androidExtension, "getApplicationVariants", "getTestVariants");
                break;
            }
            case LIBRARY: {
                variants = AndroidUtils.getVariants(androidExtension, "getLibraryVariants", "getTestVariants");
                break;
            }
            case INSTANT_APP_FEATURE: {
                variants = AndroidUtils.getVariants(androidExtension, "getFeatureVariants", "getTestVariants");
                break;
            }
            case ANDROID_TEST: {
                variants = AndroidUtils.getVariants(androidExtension, "getTestVariants");
                break;
            }
        }
        for (Object e : variants) {
            sourceSet = AndroidUtils.convertVariantToGradleSourceSet(project, e, false);
            if (sourceSet == null) continue;
            sourceSets.add(sourceSet);
        }
        if (androidProjectType != AndroidProjectType.ANDROID_TEST) {
            for (Object object : AndroidUtils.getVariants(androidExtension, "getUnitTestVariants")) {
                sourceSet = AndroidUtils.convertVariantToGradleSourceSet(project, object, true);
                if (sourceSet == null) continue;
                sourceSets.add(sourceSet);
            }
        }
        return sourceSets;
    }

    private static List<Object> getVariants(Object androidExtension, String ... methodNames) {
        LinkedList<Object> variants = new LinkedList<Object>();
        for (String methodName : methodNames) {
            try {
                variants.addAll((Collection)AndroidUtils.invokeMethod(androidExtension, methodName));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return variants;
    }

    private static GradleSourceSet convertVariantToGradleSourceSet(Project project, Object variant, boolean isUnitTest) {
        try {
            DefaultGradleSourceSet gradleSourceSet = new DefaultGradleSourceSet();
            gradleSourceSet.setBuildTargetDependencies(new HashSet<BuildTargetDependency>());
            gradleSourceSet.setGradleVersion(project.getGradle().getGradleVersion());
            gradleSourceSet.setProjectName(project.getName());
            String projectPath = project.getPath();
            gradleSourceSet.setProjectPath(projectPath);
            gradleSourceSet.setProjectDir(project.getProjectDir());
            gradleSourceSet.setRootDir(project.getRootDir());
            String variantName = (String)AndroidUtils.invokeMethod(variant, "getName");
            gradleSourceSet.setSourceSetName(variantName);
            gradleSourceSet.setClassesTaskName(SourceSetUtils.getFullTaskName(projectPath, "assemble" + AndroidUtils.capitalize(variantName)));
            gradleSourceSet.setCleanTaskName(SourceSetUtils.getFullTaskName(projectPath, "clean"));
            HashSet<String> tasks = new HashSet<String>();
            String compileTaskName = "compile" + AndroidUtils.capitalize(variantName) + "JavaWithJavac";
            tasks.add(SourceSetUtils.getFullTaskName(projectPath, compileTaskName));
            gradleSourceSet.setTaskNames(tasks);
            String projectName = SourceSetUtils.stripPathPrefix(projectPath);
            if (projectName.isEmpty()) {
                projectName = project.getName();
            }
            String displayName = projectName + " [" + variantName + ']';
            gradleSourceSet.setDisplayName(displayName);
            AndroidUtils.addModuleDependencies(gradleSourceSet, project, variant);
            AndroidUtils.addSourceAndResources(gradleSourceSet, variant, isUnitTest);
            AndroidUtils.addResourceOutputs(gradleSourceSet, variant, isUnitTest);
            ArrayList<String> compilerArgs = new ArrayList<String>();
            AndroidUtils.addGeneratedSourceAndSourceOutputs(gradleSourceSet, variant, compilerArgs);
            AndroidUtils.addClasspath(gradleSourceSet, variant);
            gradleSourceSet.setArchiveOutputFiles(new HashMap<File, List<File>>());
            gradleSourceSet.setHasTests((Boolean)AndroidUtils.hasProperty(variant, "testedVariant"));
            AndroidUtils.addExtensions(gradleSourceSet, compilerArgs);
            return gradleSourceSet;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static void addModuleDependencies(DefaultGradleSourceSet gradleSourceSet, Project project, Object variant) {
        Set<GradleModuleDependency> moduleDependencies = AndroidDependencyCollector.getModuleDependencies(project, variant);
        try {
            Object output;
            RegularFile file;
            File jarFile;
            Object androidComponents = AndroidUtils.getAndroidComponentExtension(project);
            if (androidComponents != null) {
                Object sdkComponents = AndroidUtils.getProperty(androidComponents, "sdkComponents");
                Object bootClasspath = ((Provider)AndroidUtils.getProperty(sdkComponents, "bootclasspathProvider")).get();
                try {
                    List bootClasspathFiles = (List)AndroidUtils.invokeMethod(bootClasspath, "get");
                    List sdkClasspath = bootClasspathFiles.stream().map(RegularFile::getAsFile).collect(Collectors.toList());
                    for (File file2 : sdkClasspath) {
                        moduleDependencies.add(AndroidUtils.mockModuleDependency(file2.toURI()));
                    }
                }
                catch (IllegalStateException | InvocationTargetException bootClasspathFiles) {
                    // empty catch block
                }
            }
            String taskName = "process" + AndroidUtils.capitalize(gradleSourceSet.getSourceSetName()) + "Resources";
            Task processResourcesTask = (Task)project.getTasks().findByName(taskName);
            if (processResourcesTask != null && (jarFile = (file = (RegularFile)AndroidUtils.invokeMethod(output = AndroidUtils.invokeMethod(processResourcesTask, "getRClassOutputJar"), "get")).getAsFile()).exists()) {
                moduleDependencies.add(AndroidUtils.mockModuleDependency(jarFile.toURI()));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        gradleSourceSet.setModuleDependencies(moduleDependencies);
    }

    private static void addSourceAndResources(DefaultGradleSourceSet gradleSourceSet, Object variant, boolean isUnitTest) {
        HashSet<File> sourceDirs = new HashSet<File>();
        HashSet<File> resourceDirs = new HashSet<File>();
        try {
            Object sourceSets = AndroidUtils.getProperty(variant, "sourceSets");
            if (sourceSets instanceof Iterable) {
                for (Object sourceSet : (Iterable)sourceSets) {
                    Set javaDirectories = (Set)AndroidUtils.getProperty(sourceSet, "javaDirectories");
                    sourceDirs.addAll(javaDirectories);
                    if (!isUnitTest) {
                        resourceDirs.addAll((Set)AndroidUtils.getProperty(sourceSet, "resDirectories"));
                    }
                    resourceDirs.addAll((Set)AndroidUtils.getProperty(sourceSet, "resourcesDirectories"));
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        gradleSourceSet.setSourceDirs(sourceDirs);
        gradleSourceSet.setResourceDirs(resourceDirs);
    }

    private static void addResourceOutputs(DefaultGradleSourceSet gradleSourceSet, Object variant, boolean isUnitTest) {
        HashSet<File> resourceOutputs = new HashSet<File>();
        try {
            Provider resProvider;
            Provider resourceProvider = (Provider)AndroidUtils.getProperty(variant, "processJavaResourcesProvider");
            if (resourceProvider != null) {
                Task resTask = (Task)resourceProvider.get();
                File outputDir = (File)AndroidUtils.invokeMethod(resTask, "getDestinationDir");
                resourceOutputs.add(outputDir);
            }
            if (!isUnitTest && (resProvider = (Provider)AndroidUtils.getProperty(variant, "mergeResourcesProvider")) != null) {
                Task resTask = (Task)resProvider.get();
                Object outputDir = AndroidUtils.invokeMethod(resTask, "getOutputDir");
                File output = (File)((Provider)AndroidUtils.invokeMethod(outputDir, "getAsFile")).get();
                resourceOutputs.add(output);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        gradleSourceSet.setResourceOutputDirs(resourceOutputs);
    }

    private static void addGeneratedSourceAndSourceOutputs(DefaultGradleSourceSet gradleSourceSet, Object variant, List<String> compilerArgs) {
        HashSet<File> generatedSources = new HashSet<File>();
        HashSet<File> sourceOutputs = new HashSet<File>();
        try {
            Provider javaCompileProvider = (Provider)AndroidUtils.getProperty(variant, "javaCompileProvider");
            if (javaCompileProvider != null) {
                Task javaCompileTask = (Task)javaCompileProvider.get();
                compilerArgs.addAll(AndroidUtils.getCompilerArgs((JavaCompile)javaCompileTask));
                File outputDir = (File)AndroidUtils.invokeMethod(javaCompileTask, "getDestinationDir");
                sourceOutputs.add(outputDir);
                Object source = AndroidUtils.invokeMethod(javaCompileTask, "getSource");
                Set compileSources = (Set)AndroidUtils.invokeMethod(source, "getFiles");
                for (File compileSource : compileSources) {
                    boolean inGeneratedSourceDir;
                    boolean inSourceDir = gradleSourceSet.getSourceDirs().stream().anyMatch(dir -> compileSource.getAbsolutePath().startsWith(dir.getAbsolutePath()));
                    if (inSourceDir || (inGeneratedSourceDir = generatedSources.stream().anyMatch(dir -> compileSource.getAbsolutePath().startsWith(dir.getAbsolutePath())))) continue;
                    generatedSources.add(compileSource);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        gradleSourceSet.setGeneratedSourceDirs(generatedSources);
        gradleSourceSet.setSourceOutputDirs(sourceOutputs);
    }

    private static void addClasspath(DefaultGradleSourceSet gradleSourceSet, Object variant) {
        HashSet classpathFiles = new HashSet();
        try {
            Object compileConfig = AndroidUtils.invokeMethod(variant, "getCompileConfiguration");
            classpathFiles.addAll((Set)AndroidUtils.invokeMethod(compileConfig, "getFiles"));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        gradleSourceSet.setCompileClasspath(new LinkedList<File>(classpathFiles));
    }

    private static void addExtensions(DefaultGradleSourceSet gradleSourceSet, List<String> compilerArgs) {
        HashMap<String, LanguageExtension> extensions = new HashMap<String, LanguageExtension>();
        boolean isJavaSupported = Arrays.stream(SourceSetUtils.getSupportedLanguages()).anyMatch(l -> Objects.equals(l, SupportedLanguages.JAVA.getBspName()));
        if (isJavaSupported) {
            DefaultJavaExtension extension = new DefaultJavaExtension();
            extension.setCompilerArgs(compilerArgs);
            extension.setSourceCompatibility(AndroidUtils.getSourceCompatibility(compilerArgs));
            extension.setTargetCompatibility(AndroidUtils.getTargetCompatibility(compilerArgs));
            extensions.put(SupportedLanguages.JAVA.getBspName(), extension);
        }
        gradleSourceSet.setExtensions(extensions);
    }

    private static Object getAndroidExtension(Project project) {
        return AndroidUtils.getExtension(project, "android");
    }

    private static Object getAndroidComponentExtension(Project project) {
        return AndroidUtils.getExtension(project, "androidComponents");
    }

    private static Object getExtension(Project project, String extensionName) {
        Object extension = null;
        try {
            Object convention = AndroidUtils.invokeMethod(project, "getConvention");
            Object extensionMap = AndroidUtils.invokeMethod(convention, "getAsMap");
            extension = extensionMap.getClass().getMethod("get", Object.class).invoke(extensionMap, extensionName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return extension;
    }

    private static AndroidProjectType getProjectType(Project project) {
        if (AndroidUtils.getAndroidExtension(project) == null) {
            return null;
        }
        AndroidProjectType projectType = null;
        if (project.getPluginManager().hasPlugin("com.android.application")) {
            projectType = AndroidProjectType.APPLICATION;
        } else if (project.getPluginManager().hasPlugin("com.android.library")) {
            projectType = AndroidProjectType.LIBRARY;
        } else if (project.getPluginManager().hasPlugin("com.android.dynamic-feature")) {
            projectType = AndroidProjectType.DYNAMIC_FEATURE;
        } else if (project.getPluginManager().hasPlugin("com.android.feature")) {
            projectType = AndroidProjectType.INSTANT_APP_FEATURE;
        } else if (project.getPluginManager().hasPlugin("com.android.test")) {
            projectType = AndroidProjectType.ANDROID_TEST;
        }
        return projectType;
    }

    public static Object getProperty(Object obj, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return obj.getClass().getMethod("getProperty", String.class).invoke(obj, propertyName);
    }

    public static Object hasProperty(Object obj, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return obj.getClass().getMethod("hasProperty", String.class).invoke(obj, propertyName);
    }

    private static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static GradleModuleDependency mockModuleDependency(URI jarUri) {
        String unknown = "UNKNOWN";
        LinkedList<Artifact> artifacts = new LinkedList<Artifact>();
        artifacts.add(new DefaultArtifact(jarUri, null));
        return new DefaultGradleModuleDependency("UNKNOWN", "UNKNOWN", "UNKNOWN", artifacts);
    }

    private static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
    }

    private static List<String> getCompilerArgs(JavaCompile javaCompile) {
        CompileOptions options = javaCompile.getOptions();
        try {
            DefaultJavaCompileSpec specs = AndroidUtils.getJavaCompileSpec(javaCompile);
            JavaCompilerArgumentsBuilder builder = new JavaCompilerArgumentsBuilder((JavaCompileSpec)specs).includeMainOptions(true).includeClasspath(false).includeSourceFiles(false).includeLauncherOptions(false);
            return builder.build();
        }
        catch (Exception e) {
            LinkedList compilerArgs = new LinkedList(options.getCompilerArgs());
            return compilerArgs.stream().map(Object::toString).collect(Collectors.toList());
        }
    }

    private static DefaultJavaCompileSpec getJavaCompileSpec(JavaCompile javaCompile) {
        String targetCompatibility;
        String sourceCompatibility;
        CompileOptions options = javaCompile.getOptions();
        DefaultJavaCompileSpec specs = new DefaultJavaCompileSpec();
        specs.setCompileOptions(options);
        List originalArgs = options.getCompilerArgs();
        String argsSourceCompatibility = AndroidUtils.getSourceCompatibility(originalArgs);
        String argsTargetCompatibility = AndroidUtils.getTargetCompatibility(originalArgs);
        if (!argsSourceCompatibility.isEmpty() && !argsTargetCompatibility.isEmpty()) {
            return specs;
        }
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.6")) >= 0 && options.getRelease().isPresent()) {
            specs.setRelease((Integer)options.getRelease().get());
            return specs;
        }
        if (argsSourceCompatibility.isEmpty() && specs.getSourceCompatibility() == null && (sourceCompatibility = javaCompile.getSourceCompatibility()) != null) {
            specs.setSourceCompatibility(sourceCompatibility);
        }
        if (argsTargetCompatibility.isEmpty() && specs.getTargetCompatibility() == null && (targetCompatibility = javaCompile.getTargetCompatibility()) != null) {
            specs.setTargetCompatibility(targetCompatibility);
        }
        return specs;
    }

    private static String getSourceCompatibility(List<String> compilerArgs) {
        return AndroidUtils.findFirstCompilerArgMatch(compilerArgs, Stream.of("-source", "--source", "--release")).orElse("");
    }

    private static String getTargetCompatibility(List<String> compilerArgs) {
        return AndroidUtils.findFirstCompilerArgMatch(compilerArgs, Stream.of("-target", "--target", "--release")).orElse("");
    }

    private static Optional<String> findCompilerArg(List<String> compilerArgs, String arg) {
        int idx = compilerArgs.indexOf(arg);
        if (idx >= 0 && idx < compilerArgs.size() - 1) {
            return Optional.of(compilerArgs.get(idx + 1));
        }
        return Optional.empty();
    }

    private static Optional<String> findFirstCompilerArgMatch(List<String> compilerArgs, Stream<String> args) {
        return args.map(arg -> AndroidUtils.findCompilerArg(compilerArgs, arg)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static enum AndroidProjectType {
        APPLICATION,
        LIBRARY,
        DYNAMIC_FEATURE,
        INSTANT_APP_FEATURE,
        ANDROID_TEST;

    }
}

