/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.quarkus.extensions.ollama.client;

import com.google.gson.GsonBuilder;
import com.redhat.quarkus.extensions.ollama.client.OllamaModel;
import com.redhat.quarkus.extensions.ollama.client.OllamaModelsResult;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OllamaClient {
    private static final Logger LOGGER = Logger.getLogger(OllamaClient.class.getName());
    private static final long REFRESH_OLLAMA_CACHE_TIMEOUT = 60000L;
    private String currentBaseUrl;
    private List<OllamaModel> currentModels;
    private long lastDate = -1L;

    public boolean update(String baseUrl) {
        if (!Objects.equals(baseUrl, this.currentBaseUrl)) {
            this.currentModels = null;
        }
        this.currentBaseUrl = baseUrl;
        return this.currentModels == null;
    }

    public boolean needToRefreshModels() {
        return System.currentTimeMillis() - this.lastDate > 60000L;
    }

    public List<OllamaModel> getModels() {
        if (this.currentModels == null) {
            String apiTagsUrl = this.currentBaseUrl + "/api/tags";
            this.currentModels = OllamaClient.collectOllamaModels(apiTagsUrl);
            this.lastDate = System.currentTimeMillis();
        }
        return this.currentModels;
    }

    private static List<OllamaModel> collectOllamaModels(String searchUrl) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(searchUrl)).GET().build();
            HttpResponse<String> response = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return Collections.emptyList();
            }
            String result = response.body();
            OllamaModelsResult r = (OllamaModelsResult)new GsonBuilder().create().fromJson((Reader)new StringReader(result), OllamaModelsResult.class);
            if (r != null && r.getModels() != null) {
                return r.getModels();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not connect to ollama '" + searchUrl + "': " + e.getMessage());
        }
        return Collections.emptyList();
    }
}

